# 3-Month Job Search Plan: {Name}

**Generated:** {Date}
**Career Stage:** {Early Career / Mid-Career / Senior / Executive}
**Target Direction:** {Role type or sector}
**Plan Start Date:** {Start date}
**Plan End Date:** {End date - 12 weeks later}

---

## Executive Summary

**Your Situation:**
{2-3 sentence summary of current situation, constraints, and context}

**Your Month 3 Vision:**
{What success looks like in 12 weeks - the audacious goals}

**Key Strategy:**
{1-2 sentences on the overall approach tailored to their level and situation}

**Critical Success Factors:**
1. {Factor 1 - e.g., "Network activation - 70%+ of roles come through connections"}
2. {Factor 2 - e.g., "Consistent daily rhythm - structure protects mental health"}
3. {Factor 3 - e.g., "Quality over quantity - targeted applications beat spray-and-pray"}

---

## Month 3: Audacious Goals

*"What would make this period a success?"*

### Goal 1: {Primary Career Goal}
{Specific, measurable outcome - e.g., "Accepted offer for Senior Product Manager role in fintech at £85-100k"}

**Why This Matters:**
{Connection to their values, circumstances, or career trajectory}

**Success Indicators:**
- {Indicator 1}
- {Indicator 2}
- {Indicator 3}

---

### Goal 2: {Network/Relationship Goal}
{E.g., "Built active relationships with 15+ people in my target space who know my work and capabilities"}

**Why This Matters:**
{Why networking is critical for their situation}

**Success Indicators:**
- {Indicator 1}
- {Indicator 2}

---

### Goal 3: {Skills/Development Goal}
{E.g., "Completed AWS Solutions Architect certification to strengthen cloud credentials"}

**Why This Matters:**
{How this addresses a gap or strengthens their candidacy}

**Success Indicators:**
- {Indicator 1}
- {Indicator 2}

---

### Goal 4: {Personal/Wellbeing Goal}
{E.g., "Feel confident and energised about my professional direction; maintained health and relationships throughout"}

**Why This Matters:**
{Acknowledgment that job search is a marathon, not a sprint}

**Success Indicators:**
- {Indicator 1}
- {Indicator 2}

---

## Month 2: Checkpoint (Week 8)

*"For Month 3 goals to be achievable, what must be true by Week 8?"*

### Pipeline Requirements
- [ ] {X} applications submitted to target companies
- [ ] {Y} active conversations/interviews in progress
- [ ] {Z} second-round or final interviews scheduled
- [ ] At least {N} referral-based applications

### Materials State
- [ ] CV variants for {N} role types optimised and tested
- [ ] LinkedIn profile fully optimised and active
- [ ] {Portfolio/case studies/other materials as relevant}

### Network Depth
- [ ] {N} informational interviews completed
- [ ] {N} new meaningful connections made
- [ ] {N} recruiters actively engaged
- [ ] Reactivated {N} dormant contacts

### Skills/Knowledge
- [ ] {Specific skill development milestone}
- [ ] {Industry knowledge milestone}

### Momentum Indicators
- [ ] Receiving {X} responses/interviews per week
- [ ] Confident in interview performance
- [ ] Clear on target and value proposition

---

## Month 1: Foundation (Week 4)

*"For Month 2 to be achievable, what must be true by Week 4?"*

### Materials Ready
- [ ] CV optimised for ATS and target roles
- [ ] LinkedIn profile complete and keyword-optimised
- [ ] {Additional materials as relevant}
- [ ] Cover letter templates prepared

### Target Clarity
- [ ] {N} target companies identified and researched
- [ ] {N} specific roles identified
- [ ] Clear articulation of value proposition
- [ ] Salary expectations researched and defined

### Network Activated
- [ ] Reconnected with {N} contacts
- [ ] {N} informational interviews scheduled
- [ ] Registered with {N} relevant recruiters
- [ ] LinkedIn activity established (posting/engaging)

### Habits Established
- [ ] Daily routine in place
- [ ] Application tracking system set up
- [ ] Weekly review cadence established
- [ ] Accountability partner identified

---

## Weekly Breakdown

### Week 1: Foundation & Mindset

**Theme:** Get organised, get clear, get started

**Key Outcomes:**
- [ ] CV audit and initial optimisation
- [ ] LinkedIn profile review and quick wins
- [ ] Job search tracking system set up
- [ ] Daily routine established
- [ ] Target role/company brainstorm (20+ companies)

**Daily Focus:**
- Morning: CV work and job board setup
- Afternoon: LinkedIn profile optimisation
- Evening: Target company research

**Wellbeing Focus:**
- Establish wake time and work hours
- Set up dedicated workspace
- Plan one enjoyable activity

---

### Week 2: Materials Completion

**Theme:** Polish your tools

**Key Outcomes:**
- [ ] CV finalised and ATS-tested
- [ ] LinkedIn profile fully optimised (headline, about, skills, experience)
- [ ] Cover letter template created
- [ ] Target list refined to top 15-20 companies
- [ ] Begin light networking (LinkedIn engagement)

**Daily Focus:**
- Morning: Final CV refinements
- Afternoon: LinkedIn completion
- Evening: Target company deep-dives

**Wellbeing Focus:**
- Celebrate materials completion
- Exercise/movement routine starts
- Connect with a friend

---

### Week 3: Activation Begins

**Theme:** Put yourself out there

**Key Outcomes:**
- [ ] First {5-10} applications submitted
- [ ] {5} reconnection messages sent to existing network
- [ ] {2-3} informational interview requests sent
- [ ] Daily LinkedIn engagement begins
- [ ] Recruiter registrations started

**Daily Focus:**
- Morning: Applications (1-2 per day)
- Afternoon: Networking outreach
- Evening: Industry reading/learning

**Wellbeing Focus:**
- Process first rejections with perspective
- Maintain exercise routine
- Limit job board scrolling to set times

---

### Week 4: Momentum Building

**Theme:** Build the rhythm

**Key Outcomes:**
- [ ] {10-15} total applications submitted
- [ ] {3-5} networking conversations held or scheduled
- [ ] First interview(s) possible
- [ ] Recruiter relationships established
- [ ] Content engagement consistent

**Daily Focus:**
- Morning: Applications and follow-ups
- Afternoon: Networking and conversations
- Evening: Interview prep if needed

**Monthly Review:**
- What's working? What needs adjustment?
- Pipeline health check
- Update Month 2 targets if needed

**Wellbeing Focus:**
- Celebrate Week 4 completion
- Review what's sustainable
- Adjust routine if needed

---

### Week 5: Interview Mode

**Theme:** Convert applications to conversations

**Key Outcomes:**
- [ ] Interview preparation materials ready
- [ ] STAR stories documented (5-7 stories)
- [ ] Company research process streamlined
- [ ] {5-10} new applications submitted
- [ ] Network expansion continues

**Daily Focus:**
- Morning: Applications and interview prep
- Afternoon: Networking and company research
- Evening: Interview practice

**Wellbeing Focus:**
- Manage interview anxiety with preparation
- Debrief interviews with someone
- Maintain non-work activities

---

### Week 6: Pipeline Development

**Theme:** Quality over quantity

**Key Outcomes:**
- [ ] Active interview pipeline ({N} in various stages)
- [ ] Follow-up discipline established
- [ ] Feedback from rejections sought
- [ ] Network providing introductions
- [ ] Skill development on track

**Daily Focus:**
- Morning: High-priority applications and prep
- Afternoon: Interviews and follow-ups
- Evening: Skills and reflection

**Wellbeing Focus:**
- Process any rejections
- Celebrate interview progress
- Check in with accountability partner

---

### Week 7: Refinement

**Theme:** Learn and adjust

**Key Outcomes:**
- [ ] CV/approach refined based on feedback
- [ ] Interview skills improving
- [ ] Clear on which opportunities are progressing
- [ ] Network relationships deepening
- [ ] Potential offers on horizon

**Daily Focus:**
- Morning: Targeted applications only
- Afternoon: Interview preparation and delivery
- Evening: Reflection and planning

**Wellbeing Focus:**
- Week 7 can feel long - acknowledge this
- Revisit why you're doing this
- Plan something to look forward to

---

### Week 8: Month 2 Checkpoint

**Theme:** Take stock, adjust course

**Key Outcomes:**
- [ ] Month 2 checkpoint review completed
- [ ] Pipeline assessment: on track / needs acceleration
- [ ] Second-round interviews underway
- [ ] Clear frontrunner opportunities identified
- [ ] Plan B considerations if needed

**Review Questions:**
- Are Month 3 goals still achievable? Realistic?
- What's working? Double down on it.
- What's not working? Change it.
- Is this sustainable for 4 more weeks?

**Wellbeing Focus:**
- Celebrate making it to Week 8
- Honest self-assessment (without self-criticism)
- Adjust intensity if needed

---

### Week 9: Intensification

**Theme:** Push towards finish line

**Key Outcomes:**
- [ ] Final-round interviews scheduled
- [ ] Negotiation preparation begins
- [ ] Reference list prepared
- [ ] Continued prospecting (don't stop)
- [ ] Backup options identified

**Daily Focus:**
- Morning: Interview prep and applications
- Afternoon: Interviews and negotiations
- Evening: Research and planning

**Wellbeing Focus:**
- Manage excitement/anxiety balance
- Don't celebrate until offer signed
- Keep routine stable

---

### Week 10: Decision Preparation

**Theme:** Prepare to choose

**Key Outcomes:**
- [ ] Offer(s) expected or received
- [ ] Negotiation strategies clear
- [ ] Decision criteria defined
- [ ] References contacted and briefed
- [ ] Continued prospecting until offer signed

**Daily Focus:**
- Morning: Final preparations
- Afternoon: Key conversations and interviews
- Evening: Decision reflection

**Wellbeing Focus:**
- This is high-pressure time
- Take breaks between major events
- Discuss decisions with trusted advisors

---

### Week 11: Closure

**Theme:** Bring it home

**Key Outcomes:**
- [ ] Offer negotiation in progress or complete
- [ ] Decision made or imminent
- [ ] Notice to current employer (if applicable)
- [ ] Professional closure with other processes
- [ ] Thank-you notes to network helpers

**Daily Focus:**
- Focus on closing active opportunities
- Wrap up other processes professionally
- Plan transition

**Wellbeing Focus:**
- Manage offer excitement carefully
- Don't burn bridges with other companies
- Start thinking about successful onboarding

---

### Week 12: Transition

**Theme:** Close this chapter, open the next

**Key Outcomes:**
- [ ] Offer accepted and signed
- [ ] Start date confirmed
- [ ] Network thanked and updated
- [ ] Lessons documented
- [ ] Celebration!

**If Still Searching:**
- Review entire 3-month period
- Identify what needs to change
- Create next 3-month plan
- Seek additional support if needed

**Wellbeing Focus:**
- Celebrate the journey, not just the outcome
- Acknowledge what you learned
- Prepare for new chapter

---

## Daily Rhythm Template

### Suggested Daily Structure

**Morning (9:00 - 12:00)**
| Time | Activity | Duration |
|------|----------|----------|
| 9:00 | Start routine, review day's priorities | 30 min |
| 9:30 | Job board scan and application work | 90 min |
| 11:00 | Short break | 15 min |
| 11:15 | Company research / interview prep | 45 min |

**Midday Break (12:00 - 13:00)**
- Lunch away from desk
- Exercise/walk
- Non-work activity

**Afternoon (13:00 - 17:00)**
| Time | Activity | Duration |
|------|----------|----------|
| 13:00 | Networking outreach and follow-ups | 60 min |
| 14:00 | LinkedIn engagement (meaningful comments) | 30 min |
| 14:30 | Informational interviews / calls | 60-90 min |
| 16:00 | Skills development / industry reading | 60 min |
| 17:00 | Day wrap-up, tomorrow planning | 15 min |

**Evening**
- Clear end-of-work ritual
- Non-work activities
- Connection with friends/family
- Prepare for tomorrow

### Adapting for Career Level

**Early Career (6-8 hours daily):**
- More application volume
- More skill development time
- Broader networking

**Senior/Executive (4-6 hours daily):**
- Fewer, targeted applications
- More relationship-focused activity
- Thought leadership content creation
- Strategic networking

---

## Weekly Task Checklist

### Recurring Weekly Tasks

**Applications & Search:**
- [ ] {N} targeted applications submitted
- [ ] Follow up on applications from last week
- [ ] Update application tracker
- [ ] Research {N} new target companies

**Networking:**
- [ ] Send {N} new outreach messages
- [ ] Have {N} networking conversations
- [ ] Engage with {N} LinkedIn posts meaningfully
- [ ] Post or share {N} piece of content

**Skills & Preparation:**
- [ ] Complete {X hours} of skill development
- [ ] Read {N} industry articles
- [ ] Practice interview responses
- [ ] Update STAR stories if needed

**Administration:**
- [ ] Review and update CV if needed
- [ ] Check LinkedIn analytics
- [ ] Update recruiter contacts
- [ ] Review weekly goals

**Wellbeing:**
- [ ] Exercise {N} times
- [ ] Connect with friend/family (non-work conversation)
- [ ] One enjoyable activity
- [ ] Reflect on wins (however small)

### Weekly Review Questions

**Friday or Sunday, 30 minutes:**
1. What worked well this week?
2. What didn't work? What will I change?
3. What am I most proud of?
4. What interviews/conversations do I have next week?
5. What are my top 3 priorities for next week?
6. How am I feeling? Do I need to adjust intensity?
7. Who should I thank or follow up with?

---

## Wellbeing Practices

### Daily Non-Negotiables

1. **Wake at consistent time** - Structure protects mental health
2. **Get dressed** - Real clothes, not loungewear
3. **Move your body** - Walk, exercise, stretch
4. **End work at a set time** - Create clear boundaries
5. **One non-work activity** - Maintain your identity

### Managing the Hard Days

**When rejection comes:**
- Feel the disappointment (don't suppress it)
- Remember: it's a numbers game, not personal judgment
- Ask for feedback if appropriate
- Give yourself 24 hours, then move forward
- Talk to someone

**When motivation dips:**
- Start with smallest possible task
- Change environment (work from cafe, library)
- Review your wins list
- Connect with accountability partner
- Remember why you're doing this

**Warning signs to watch for:**
- Multiple days of no activity
- Withdrawing from people
- Sleep or appetite changes
- Persistent feelings of worthlessness

**If you're struggling:** Please talk to someone - friend, family, GP, or:
- Mind: mind.org.uk
- NHS Talking Therapies: Self-refer via NHS website
- Samaritans: 116 123 (24/7)

### Building Resilience

**Notice the small wins:**
- Application submitted - that took effort
- Message sent - networking is uncomfortable, well done
- Interview completed - regardless of outcome, you showed up
- New connection made - relationships compound over time
- Something learned - progress isn't always visible

Consider keeping a simple "wins list" - it's surprisingly helpful on difficult days.

**Keeping perspective:**
- A typical job search takes around 5 months - you're not behind
- Most applications don't lead to interviews (that's the maths, not personal rejection)
- Networking takes time to pay off - plant seeds now, harvest later
- Rejection is feedback, though it rarely feels that way in the moment

---

## Progress Tracking

### Application Tracker

| Company | Role | Date Applied | Source | Status | Follow-up Date | Notes |
|---------|------|--------------|--------|--------|----------------|-------|
| | | | | | | |

**Status codes:** Applied / Screening / Interview 1 / Interview 2 / Final / Offer / Rejected / Withdrawn

### Network Tracker

| Name | Company/Role | How Connected | Last Contact | Next Action | Notes |
|------|--------------|---------------|--------------|-------------|-------|
| | | | | | |

### Weekly Metrics

| Week | Applications | Responses | Interviews | Networking Calls | LinkedIn Engagement |
|------|--------------|-----------|------------|------------------|---------------------|
| 1 | | | | | |
| 2 | | | | | |
| ... | | | | | |
| 12 | | | | | |

### Monthly Reflection

**Month 1 Reflection:**
- Applications submitted:
- Interviews secured:
- Network conversations:
- What worked:
- What to change:
- How I'm feeling:

**Month 2 Reflection:**
{Same structure}

**Month 3 Reflection:**
{Same structure}

---

## Resources & Tools

### Recommended Tools

**Job Boards:**
- LinkedIn Jobs
- Indeed
- Glassdoor
- Sector-specific boards: {relevant to their industry}

**Application Tracking:**
- Spreadsheet (simple and effective)
- Notion
- Huntr
- Teal

**LinkedIn Optimisation:**
- Headline formula: [Title] | [Specialism] | [Value proposition]
- Skills: 20-30 relevant skills, top 3 most important first
- Engagement: Comment meaningfully 3-5x weekly

**Interview Preparation:**
- STAR method for behavioural questions
- Research: Company website, news, Glassdoor, LinkedIn
- Questions to ask: Business, team, role, culture

### Recommended Reading & Listening

**For Your Sector:**
{Tailored recommendations based on their specific industry and role - ask them what's respected in their field}

**Podcasts (sector-specific):**
- {If Digital Delivery/Agile/PM:} The Delivery Manager Daily by Mario De'Cristofano - [Spotify](https://open.spotify.com/show/6jhTwJOEZOjAytXBRz47NU) - Practical, no-BS advice for delivery roles
- {For other sectors:} Research and recommend podcasts relevant to their specific field

**Job Search Strategy:**
- "What Color Is Your Parachute?" - Richard N. Bolles
- LHH Resources (lhh.com/uk) - Free career transition guides

**Networking:**
- "Never Eat Alone" - Keith Ferrazzi
- LinkedIn Learning courses on networking

**Mindset & Resilience:**
- "Designing Your Life" - Burnett & Evans
- "The Obstacle Is the Way" - Ryan Holiday

**Your Sector-Specific Resources:**
{Ask: "What communities, publications, or podcasts are respected in your field?" and add them here}

### Support Resources

**Career Transition:**
- LHH (Lee Hecht Harrison) - lhh.com/uk
- Career Counselling services

**Recruitment Partners:**
- Harvey Nash - Technology/digital leadership
- Macildowie - Finance, HR, marketing
- GenX Talent - Experienced professionals (linkedin.com/company/genx-talent)
- Crimson Recruitment - Multi-sector

**Government Support:**
- Jobcentre Plus
- National Careers Service: nationalcareers.service.gov.uk
- Skills Bootcamps (funded training)

**Mental Health:**
- Mind: mind.org.uk
- NHS Talking Therapies: nhs.uk/talk-to-someone
- Mental Health UK Into Work Programme

---

## Contingency Planning

### If Month 3 Goals Not Met

**Don't panic. Reassess:**

1. **Was the goal realistic?** Adjust if needed
2. **What's working?** Do more of it
3. **What's not?** Change approach, not just effort
4. **What feedback have you received?** Act on it
5. **Do you need support?** Career coach, mentor, counselling

**Plan B Options to Consider:**
- Interim/contract roles while continuing search
- Fractional/consulting work
- Skills development or retraining
- Broader geographic or sector search
- Portfolio career approach

### If Financial Pressure Increases

- Accelerate applications to "good enough" roles
- Consider interim/contract work
- Review expenses and runway
- Explore benefits eligibility
- Seek support early, not as last resort

### If Mental Health Declines

- This is normal and not weakness
- Reduce intensity, don't stop completely
- Seek professional support
- Lean on personal support network
- Remember: your worth is not your employment status

---

## Final Notes

### What Success Looks Like

Success isn't simply "getting a job." A successful search means:
- Learning about yourself and what you genuinely want from work
- Building relationships that will outlast any single role
- Developing resilience and self-knowledge through challenge
- Maintaining your health and important relationships
- Finding a role that genuinely fits, not just any role

### A Few Things Worth Remembering

- Most roles (70-85%) come through networking - it's worth the investment
- Quality beats quantity - five thoughtful applications often outperform fifty generic ones
- Structure helps - a routine isn't boring, it's protective
- This takes time - a typical search runs several months, so pace yourself
- Your worth isn't your job title - you're the same capable person whether employed or not

### A Word of Encouragement

Job searching is genuinely hard work. It tests your confidence, your patience, and your resilience. There will be difficult days.

But you have skills, experience, and genuine value to offer. This plan provides structure and direction. What matters is showing up, day after day, even when it's hard - and being kind to yourself when you need to rest.

This plan is a starting point, not a rigid prescription. Adapt it to what works for you. Ask for help when you need it. Celebrate the small wins along the way.

You're not alone in this, and you're more capable than you might feel right now.

---

*Generated using Career Helper skill by Paul Bratcher ([LinkedIn](https://www.linkedin.com/in/paul-bratcher/) | [GitHub](https://github.com/Zal4DW/career-helper)). Found this helpful? Share your success story or suggest improvements on GitHub!*
