---
name: career-transitions
description: This skill should be used when the user asks to "go fractional", "build a portfolio career", "become a fractional executive", "assess my AI readiness", or "how do I show AI skills". Provides portfolio and fractional career support with regional tax and legal guidance, and AI readiness assessment with upskilling roadmaps.
tags: portfolio, fractional, career-change, ai-readiness, transition, executive
---

# Career Transitions

Support for non-traditional career paths - fractional executive roles, portfolio careers, and AI readiness.

## Capabilities

| # | Capability | When to Use |
|:--|:-----------|:------------|
| 1 | Portfolio & Fractional Careers | Transitioning to or building non-traditional career |
| 2 | AI Readiness Assessment | Assessing and improving AI competency for job search |

## Quick Start

```
"I want to go fractional/portfolio"
"Help me become a fractional CFO/CMO/CTO"
"How do I demonstrate AI skills for jobs?"
"Assess my AI readiness for [target role]"
```

---

## 1. Portfolio & Fractional Career Support

**What you need:** Skills inventory, income goals, target regions, current situation
**Load:** @references/portfolio-career.md
**Template:** @references/portfolio-career-template.md

Comprehensive portfolio career strategy:
- Readiness assessment (financial, skills, personal)
- Portfolio design with income stream mapping
- Fractional executive positioning (CFO, CMO, CTO, CPO)
- Rate setting guidance by role and region
- Client acquisition strategy and platforms
- LinkedIn optimisation for fractional/portfolio positioning
- Portfolio CV format

**Legal and Tax Structure Options:**
- UK: IR35 considerations, Ltd company vs sole trader, NI implications
- US: 1099 vs W-2, self-employment tax, LLC vs S-Corp, state variations
- EU: VAT registration, cross-border invoicing, local regulations

**Output:** `portfolio-career-strategy.md`

---

## 2. AI Readiness Assessment

**What you need:** Current role, target roles, existing AI experience
**Load:** @references/ai-readiness.md
**Template:** @references/ai-readiness-template.md

AI skills development for the modern job market:
- Current AI proficiency assessment (tools, applications, understanding)
- Gap analysis for target role requirements (via WebSearch)
- Tiered upskilling roadmap (immediate, foundation, differentiation)
- CV and LinkedIn AI integration strategies
- Interview preparation for AI-related questions
- Portfolio project recommendations

**Output:** `ai-readiness-plan.md`

---

## Output Standards

- **UK English** throughout (unless US role explicitly requires)
- **No emojis** - Professional tone
- **Cited sources** - Research includes URLs and access dates
- **Region-aware** - Adapt tax, legal, and market guidance to specified region
- **Actionable** - Clear next steps with timelines
- **Disclaimer** - Regional guidance is general information only; consult qualified professionals

### Template Usage

When a capability specifies a template, you MUST:
1. Load the template first using @ symbol
2. Follow the template structure exactly
3. Preserve template footers

---

## Related Skills

- **/linkedin-coach** - Optimise your LinkedIn for fractional/portfolio positioning
- **/career-navigator** - Build a 3-month plan, negotiate rates
- **/application-optimiser** - Research target companies for fractional roles

---

*Career Transitions v1.2.0 | Career Helper Plugin | Prosper AI Consulting, UK*
