# Interview Preparation: {Role Title} at {Company Name}

**Generated:** {Date}
**Target Role:** {Role Title}
**Company:** {Company Name}
**Interview Stage:** {Initial Screening / Technical / Panel / Final - adjust as needed}

---

## Interview Intelligence

### Likely Interview Format
{Based on company research and role level}
- **Format:** {Phone/Video/In-person}
- **Duration:** {Expected length}
- **Interviewers:** {Likely participants based on research}
- **Structure:** {Behavioral/Technical/Case study mix expected}

### Company-Specific Interview Style
{From Glassdoor, company content, or industry norms}

---

## Likely Interview Questions

### Category 1: Behavioral Questions

#### Question 1: {Question text}

**Interviewer's Perspective:**

*What They're Really Assessing:*
{The underlying competency, behaviour, or fit being evaluated - be specific}

*What Makes a Strong Answer:*
- {Criterion 1 - what good looks like}
- {Criterion 2 - what demonstrates mastery}
- {Criterion 3 - what sets excellent apart}

*Red Flags They Watch For:*
- {Red flag 1 - what makes them concerned}
- {Red flag 2 - common mistakes}

*How to Think About Your Answer:*
{Mental framework - not a script, but a thinking approach}

**Your Prepared Response:**

**Recommended Structure:**
{STAR or other structure recommendation}

**Your Answer Framework:**
- **Situation:** {Specific example from CV - Company X, Project Y, Time period}
- **Task:** {Your responsibility or challenge}
- **Action:** {What you did - emphasize skills from JD}
- **Result:** {Quantified outcome - tie to keywords}

**Key Points to Emphasize:**
- {Keyword or concept from JD this addresses}
- {Keyword or concept from JD this addresses}

**Evidence from Your Background:**
{Specific bullet from CV line X or experience at Company Y}

---

#### Question 2: {Question text}

**Why They're Asking:**
{What they want to learn}

**Recommended Structure:**
{Structure recommendation}

**Your Answer Framework:**
- **Situation:** {Specific example}
- **Task:** {Your responsibility}
- **Action:** {What you did}
- **Result:** {Quantified outcome}

**Key Points to Emphasize:**
- {Keyword/concept}
- {Keyword/concept}

**Evidence from Your Background:**
{Specific reference}

---

{Repeat for 15-20 likely questions, organized by category}

---

### Category 2: Technical/Functional Questions

#### Question X: {Question text}

**Why They're Asking:**
{What competency they're assessing}

**Your Answer Approach:**
{How to structure response - may not be STAR, might be explanation + example}

**Key Concepts to Cover:**
- {Concept 1}
- {Concept 2}
- {Concept 3}

**Examples from Your Experience:**
{Specific projects, tools used, outcomes achieved}

**Relevant Citations (if applicable):**
- {Industry best practice or source if relevant}

---

### Category 3: Situational/Hypothetical Questions

#### Question Y: {Question text}

**Why They're Asking:**
{What they want to assess - decision-making, values, approach}

**Your Answer Framework:**
{How to structure response}

**Principles to Demonstrate:**
- {Principle 1 aligned with company values}
- {Principle 2 aligned with role requirements}

**Similar Real Situation:**
{Actual experience that provides credibility}

---

### Category 4: Company-Specific Questions

#### Question Z: "Why {Company Name}?"

**Your Answer:**

{2-3 paragraph answer that demonstrates:
- Specific research about company
- Alignment with their mission/products/culture
- How your background fits their current needs
- Genuine enthusiasm backed by facts}

**Research Points to Mention:**
- {Specific recent development or initiative}
- {Company differentiation in market}
- {Aspect of culture or values that resonates}

**Sources to Reference (if appropriate):**
- {Recent article, interview, product launch}

---

#### "Why This Role?"

**Your Answer:**

{2-3 paragraph answer that shows:
- Clear understanding of role requirements
- Connection to your career progression
- Specific aspects that excite you
- How you'll add value}

---

#### "Why Leave Your Current Role?"

**Your Answer:**

{Professional, positive explanation that:
- Focuses on opportunity ahead, not problems behind
- Shows career growth logic
- Demonstrates enthusiasm for target company
- Avoids negativity}

---

## Your STAR Stories (Pre-Prepared)

These are your strongest examples that can be adapted for multiple questions.

### STAR Story 1: {Brief Title - e.g., "Team Transformation"}

**Situation:**
{Context - company, timeframe, challenge}

**Task:**
{Your specific responsibility}

**Action:**
{What you did - 3-4 specific actions}
- {Action 1 with tool/method}
- {Action 2 with tool/method}
- {Action 3 with tool/method}

**Result:**
{Quantified outcomes}
- {Metric 1}
- {Metric 2}

**Keywords This Covers:**
{keyword 1}, {keyword 2}, {keyword 3}

**Questions This Answers:**
- {Question type 1}
- {Question type 2}

---

### STAR Story 2: {Brief Title}

{Repeat structure}

---

{Include 5-7 strong STAR stories that cover different competencies}

---

## Questions for You to Ask

Ask 3-5 questions in each interview. Organize by interview stage and audience.

### For Hiring Manager:

1. **{Question 1}**
   - Why ask: {Shows you understand role/company, seeks critical info}
   - What to listen for: {Key signals}

2. **{Question 2}**
   - Why ask: {Demonstrates strategic thinking}
   - What to listen for: {Key signals}

3. **{Question 3}**
   - Why ask: {Probes culture/expectations}
   - What to listen for: {Red flags or green lights}

### For Team Members:

1. **{Question 1}**
   - Why ask: {Gets real picture of daily work}
   - What to listen for: {Insights into team dynamics}

2. **{Question 2}**
   - Why ask: {Understands challenges}
   - What to listen for: {Team health signals}

### For Executives/Senior Leaders:

1. **{Question 1}**
   - Why ask: {Shows strategic perspective}
   - What to listen for: {Company direction}

2. **{Question 2}**
   - Why ask: {Demonstrates business acumen}
   - What to listen for: {Strategic priorities}

---

## Talking Points to Weave In

These are key messages to deliver across multiple questions:

1. **{Talking Point 1}**
   - Core message: {Your strength/value prop}
   - Evidence: {Brief example or metric}
   - Relevant to: {JD requirement X}

2. **{Talking Point 2}**
   - Core message: {Your differentiator}
   - Evidence: {Brief example or metric}
   - Relevant to: {JD requirement Y}

3. **{Talking Point 3}**
   - Core message: {Your leadership philosophy or approach}
   - Evidence: {Brief example or metric}
   - Relevant to: {Cultural fit}

---

## Potential Concerns to Address

Based on gap analysis, proactively address:

### Concern 1: {Identified gap or potential objection}

**How to Address:**
{Strategy to reframe or provide compensating evidence}

**Proactive Statement:**
"{Exact wording to use if topic arises}"

### Concern 2: {Identified gap}

**How to Address:**
{Strategy}

**Proactive Statement:**
"{Wording}"

---

## Practical Preparation

### Before Interview Day:

**Technical Setup (for video):**
- [ ] Test camera, microphone, lighting
- [ ] Choose quiet location with professional background
- [ ] Have backup device ready
- [ ] Close unnecessary applications
- [ ] Silence phone notifications

**Materials Ready:**
- [ ] CV printed (or visible on screen)
- [ ] Research brief printed
- [ ] This interview prep printed
- [ ] Questions for them written down
- [ ] Notebook for taking notes
- [ ] Water nearby

**Mental Preparation:**
- [ ] Review STAR stories
- [ ] Practice answering top 5 likely questions aloud
- [ ] Review company research
- [ ] Visualize successful interview

### Day Of:

- [ ] Arrive/login 10 minutes early
- [ ] Review key talking points
- [ ] Take 3 deep breaths before starting
- [ ] Remember: they want you to succeed

### During Interview:

- **Active Listening:** Take notes on questions and responses
- **Pace:** Pause before answering, speak at measured pace
- **Examples:** Always tie back to specific experience
- **Enthusiasm:** Show genuine interest and energy
- **Clarify:** Ask for clarification if question unclear
- **Bridge:** Connect your answers to their needs

### After Interview:

- [ ] Send thank you email within 24 hours
- [ ] Note key topics discussed for follow-up
- [ ] Update your interview log
- [ ] Reflect on what went well, what to adjust

---

## Thank You Email Template

**Subject:** Thank you - {Role Title} Interview

Dear {Interviewer Name},

{Paragraph 1: Thank them, reference specific topic from conversation that resonated}

{Paragraph 2: Reinforce your interest, mention 1-2 key qualifications that align with discussed needs}

{Paragraph 3: Offer to provide additional information, express enthusiasm for next steps}

Best regards,
{Your Name}

**Send Timing:** Within 24 hours, ideally same day
**Tone:** Professional, warm, specific (not generic)

---

## Citations & Research Sources

{List all sources used to prepare this brief}

1. [{Source 1}]({URL}) - Accessed {Date}
2. [{Source 2}]({URL}) - Accessed {Date}
3. {Company Glassdoor reviews} - Accessed {Date}

---

## Customization Notes

This prep guide is tailored for:
- **Role:** {Target Role}
- **Level:** {Seniority Level}
- **Industry/Sector:** {Industry or sector}
- **Organization Type:** {Startup/Scaleup/Enterprise/Government/Non-profit/Academic/etc.}

For different roles or interview stages, regenerate with updated context.

---

*Generated using Career Helper skill by Paul Bratcher ([LinkedIn](https://www.linkedin.com/in/paul-bratcher/) | [GitHub](https://github.com/Zal4DW/career-helper)). Found this helpful? Share your success story or suggest improvements on GitHub!*
