# Interviewer's Perspective: {Role Title} at {Company Name}

**Generated:** {Date}
**Target Role:** {Role Title}
**Company:** {Company Name}
**Interview Stage:** {Initial Screening / Technical / Panel / Final}

---

## How to Use This Report

This report shows interview questions **from the interviewer's viewpoint**. It explains:
- What they're really assessing behind each question
- What makes answers strong vs weak
- Red flags that concern interviewers
- How to THINK about your answer (not what to say)

**Use this alongside your full Interview Prep** for comprehensive preparation.

---

## Behavioural Questions

These assess past behaviour as a predictor of future performance.

---

### Question 1: "{Question text}"

**What the Interviewer is Really Assessing:**
{The underlying competency, behaviour, or fit being evaluated}

**What Makes a Strong Answer:**
- {Criterion 1}
- {Criterion 2}
- {Criterion 3}

**Red Flags They're Watching For:**
- {Red flag 1}
- {Red flag 2}
- {Red flag 3}

**How to Think About Your Answer:**
{Mental framework for constructing your response}

Start by asking yourself: {Opening question}
Then consider: {Second layer}
Finally: {How to conclude}

**Your Experience to Draw From:**
{Specific reference to their CV that could be relevant}

---

### Question 2: "{Question text}"

**What the Interviewer is Really Assessing:**
{Assessment focus}

**What Makes a Strong Answer:**
- {Criterion 1}
- {Criterion 2}
- {Criterion 3}

**Red Flags They're Watching For:**
- {Red flag 1}
- {Red flag 2}
- {Red flag 3}

**How to Think About Your Answer:**
{Mental framework}

**Your Experience to Draw From:**
{CV reference}

---

{Repeat for 5-6 behavioural questions}

---

## Situational Questions

These test your judgment through hypothetical scenarios.

---

### Question 3: "{Question text}"

**What the Interviewer is Really Assessing:**
{Assessment focus}

**What Makes a Strong Answer:**
- {Criterion 1}
- {Criterion 2}
- {Criterion 3}

**Red Flags They're Watching For:**
- {Red flag 1}
- {Red flag 2}
- {Red flag 3}

**How to Think About Your Answer:**
{Mental framework}

**Your Experience to Draw From:**
{Similar situations from CV to reference}

---

{Repeat for 3-4 situational questions}

---

## Role-Specific Questions

These assess competencies specific to this role and job description.

---

### Question 4: "{Question text}"

**What the Interviewer is Really Assessing:**
{Technical or functional competency being tested}

**What Makes a Strong Answer:**
- {Criterion 1}
- {Criterion 2}
- {Criterion 3}

**Red Flags They're Watching For:**
- {Red flag 1}
- {Red flag 2}
- {Red flag 3}

**How to Think About Your Answer:**
{Mental framework specific to this domain}

**Your Experience to Draw From:**
{Relevant technical/functional experience from CV}

---

{Repeat for 2-3 role-specific questions}

---

## Cultural Fit Questions

These assess alignment with company values and working style.

---

### Question 5: "{Question text}"

**What the Interviewer is Really Assessing:**
{Values or cultural fit being evaluated}

**What Makes a Strong Answer:**
- {Criterion 1}
- {Criterion 2}
- {Criterion 3}

**Red Flags They're Watching For:**
- {Red flag 1}
- {Red flag 2}
- {Red flag 3}

**How to Think About Your Answer:**
{Mental framework for authenticity}

**Your Experience to Draw From:**
{Examples of cultural alignment from CV}

---

{Repeat for 2-3 cultural fit questions}

---

## The "Why" Questions

These assess motivation and fit for this specific opportunity.

---

### "Why do you want this role?"

**What the Interviewer is Really Assessing:**
Have you done your homework? Is this a considered choice or are you spraying applications? Do you understand what the role actually involves?

**What Makes a Strong Answer:**
- Specific references to job description elements that excite you
- Connection to your career trajectory (logical next step)
- Evidence you understand the challenges and opportunities
- Genuine enthusiasm backed by research

**Red Flags They're Watching For:**
- Generic answers that could apply to any role
- Focus only on what you'll GET (title, money, brand)
- No mention of specific job responsibilities
- Can't articulate why THIS role vs similar roles elsewhere

**How to Think About Your Answer:**
Start with: "What specific parts of the JD genuinely interest me and why?"
Then: "How does this connect to what I've done and where I want to go?"
Finally: "What do I understand about the challenges I'd be taking on?"

---

### "Why do you want to leave your current role?"

**What the Interviewer is Really Assessing:**
Are you running FROM problems or running TO opportunity? Will you bring negativity? Is there a pattern of dissatisfaction?

**What Makes a Strong Answer:**
- Leads with appreciation for current role
- Focuses on growth opportunity ahead
- Explains timing (why now)
- Shows this is a considered, not reactive, decision

**Red Flags They're Watching For:**
- Badmouthing current employer
- Vague "new challenges" without specifics
- Primarily money or title motivated
- Desperation or urgency suggesting they're being pushed out

**How to Think About Your Answer:**
Start with: "What have I genuinely valued and accomplished where I am?"
Then: "What growth am I seeking that I can't get there?"
Finally: "Why is THIS role the right next step?"

---

### "Why {Company Name}?"

**What the Interviewer is Really Assessing:**
Have you researched us? Do you understand what makes us different? Would you choose us over competitors?

**What Makes a Strong Answer:**
- Specific, researched facts about the company
- Alignment with company mission or values
- Understanding of company's market position
- Connection between company direction and your skills

**Red Flags They're Watching For:**
- Generic praise ("great company, market leader")
- Facts that are wrong or outdated
- No mention of anything specific to THIS company
- Obvious flattery without substance

**How to Think About Your Answer:**
Start with: "What do I genuinely find interesting about this company?"
Then: "What specific things have I learned from research?"
Finally: "How does what they're doing connect to what I want to do?"

---

## Quick Reference: Universal Red Flags

Interviewers are trained to watch for these across ALL questions:

| Red Flag | What It Signals |
|:---------|:----------------|
| **Vague answers** | Lack of real experience or hiding something |
| **Taking solo credit** | Poor team player, inflated self-assessment |
| **Blaming others** | Lack of accountability, victim mentality |
| **No metrics or outcomes** | Can't measure own impact |
| **Talking too long** | Poor communication, can't be concise |
| **Not answering the question** | Evasive or unprepared |
| **Negativity about past roles** | Will likely be negative about this one too |
| **Overconfidence** | May not be coachable, blind spots |
| **Underconfidence** | May not be ready for the role |

---

## Quick Reference: What Strong Candidates Do

| Behaviour | Why It Impresses |
|:----------|:-----------------|
| **Pause before answering** | Shows thoughtfulness, not rehearsed |
| **Ask clarifying questions** | Shows engagement, gets to real question |
| **Use specific examples** | Demonstrates real experience |
| **Acknowledge complexity** | Shows mature thinking |
| **Own failures honestly** | Shows self-awareness and growth |
| **Connect to their needs** | Shows empathy and research |
| **Be appropriately concise** | Respects their time, good communicator |

---

## Next Steps

1. **Review each question** - Identify which you feel confident about vs need practice
2. **Identify your stories** - For each question, note 1-2 experiences from your CV
3. **Practice thinking aloud** - Use the frameworks to construct answers in real-time
4. **Pair with Full Interview Prep** - Get specific STAR answers for your top questions

---

## Research Sources

{List all sources used to inform company-specific questions}

1. [{Source}]({URL}) - Accessed {Date}
2. [{Source}]({URL}) - Accessed {Date}

---

*Generated using Career Helper skill by Paul Bratcher ([LinkedIn](https://www.linkedin.com/in/paul-bratcher/) | [GitHub](https://github.com/Zal4DW/career-helper)). Found this helpful? Share your success story or suggest improvements on GitHub!*
