# Post-Interview Debrief: {Role Title} at {Company Name}

**Generated:** {Date}
**Role:** {Role Title}
**Company:** {Company Name}
**Rejection Stage:** {Application / Recruiter Screen / HM Screen / Technical / Final Round / Post-Offer}
**Date of Rejection:** {Date}
**Rejection Count (This Search):** {Number}

---

## 1. Rejection Context

### The Opportunity
- **Role:** {Role title and level}
- **Company:** {Company name and brief context}
- **Why It Mattered:** {Why this role was attractive to you}

### The Process Timeline
| Stage | Date | Duration | Outcome |
|-------|------|----------|---------|
| Application | {Date} | - | Progressed |
| {Next stage} | {Date} | {Duration} | {Outcome} |
| {Final stage reached} | {Date} | {Duration} | Rejected |

### Interviewers Met
{If applicable}
- {Name} - {Title} - {Notes on interaction}
- {Name} - {Title} - {Notes on interaction}

---

## 2. What Happened: Factual Reconstruction

### At {Stage Where Rejected}

**Format:** {Phone/Video/In-person, duration, structure}

**Questions Asked:**
1. {Question 1}
   - Your answer summary: {Brief}
   - How it felt: {Well/Okay/Struggled}

2. {Question 2}
   - Your answer summary: {Brief}
   - How it felt: {Well/Okay/Struggled}

{Continue for key questions}

**Your Questions to Them:**
- {Question you asked}
- {Their response summary}

**Overall Impression Leaving:**
{How did you feel the interview went? What signals did you pick up?}

**Any Red Flags or Awkward Moments:**
{Anything that felt off during the process}

---

## 3. Feedback Received

### Direct Feedback
{Copy any feedback received verbatim}

"{Exact words from recruiter/company}"

### Feedback Decoding

| They Said | Likely Meaning | Confidence |
|-----------|---------------|------------|
| {Phrase 1} | {Interpretation} | {High/Medium/Low} |
| {Phrase 2} | {Interpretation} | {High/Medium/Low} |

### What We Can't Know
{Acknowledge uncertainty - what factors are unknowable}
- {Unknown factor 1 - e.g., internal candidates, budget changes}
- {Unknown factor 2}

---

## 4. Gap Diagnosis

### Primary Diagnosis: {SKILL GAP / SIGNAL GAP / FIT-TIMING GAP}

**Confidence Level:** {High / Medium / Low}

**Reasoning:**
{Explain why this diagnosis based on evidence:}
- {Evidence point 1}
- {Evidence point 2}
- {Evidence point 3}

### Alternative Explanation
{Could it be something else? Acknowledge uncertainty}
- {Alternative interpretation and why less likely}

### Stage-Appropriate Context
{Calibrate the diagnosis to the stage}

> {Stage}-level rejections typically indicate {what this stage assesses}. This {does/doesn't} tell us much about {what it doesn't assess}.

---

## 5. Skills Analysis

### Skills Required by Role (from JD)

| Skill | Your Evidence | Demonstrated in Interview? | Future Demand (WEF 2025) |
|-------|--------------|---------------------------|-------------------------|
| {Skill 1} | {From CV} | {Yes/Partially/No/Not Asked} | {Rising/Stable/Declining} |
| {Skill 2} | {From CV} | {Yes/Partially/No/Not Asked} | {Rising/Stable/Declining} |
| {Skill 3} | {From CV} | {Yes/Partially/No/Not Asked} | {Rising/Stable/Declining} |

### Gap Priority Matrix

| Gap Identified | Role Required? | Future Demand | Priority | Recommended Action |
|----------------|---------------|---------------|----------|-------------------|
| {Gap 1} | Yes | +{X}% growth | CRITICAL | {Action} |
| {Gap 2} | Yes | Stable | HIGH | {Action} |
| {Gap 3} | No | +{X}% growth | STRATEGIC | {Action} |

### Skills You Demonstrated Well
{Positive evidence from the interview}
- {Skill 1}: {How demonstrated}
- {Skill 2}: {How demonstrated}

---

## 6. What's Still True

Despite this rejection, the following remains true about your capabilities:

### Your Track Record
{Evidence anchor from CV - specific achievements that haven't changed}

- You still have **{X years}** experience in **{domain}**
- You still achieved **{specific accomplishment with metric}** at {Company}
- You still delivered **{specific accomplishment with metric}**
- You still have demonstrated expertise in **{skill area}**

### This Process Validated
{What the interview process itself confirmed}

- {Company} considered you qualified enough to invite to {stage reached}
- You successfully communicated {what went well}
- {Any positive feedback or signals received}

### The Rejection Does NOT Mean
{Explicitly counter unhelpful narratives}

- It does NOT mean you lack capability for this level of role
- It does NOT mean your experience is inadequate
- It does NOT mean you misread your potential
- It reflects alignment with ONE role at ONE company at ONE moment

---

## 7. Action Plan

### Immediate (Next 24-48 Hours)

**Emotional Reset:**
- [ ] {Acknowledge disappointment - it's legitimate}
- [ ] {Take a break from applications if needed}
- [ ] {Do one non-job-search activity you enjoy}

**Administrative:**
- [ ] Send thank-you/feedback request to {contact} (template below)
- [ ] Update application tracking spreadsheet
- [ ] Connect with interviewers on LinkedIn (if appropriate)

### This Week

**Based on {Diagnosis Type} Diagnosis:**

{If SKILL GAP:}
- [ ] Research learning resources for {specific skill}
- [ ] Identify one project/course to start this week
- [ ] Map adjacent roles that build this skill

{If SIGNAL GAP:}
- [ ] Rewrite STAR story for {topic that didn't land}
- [ ] Practice "Tell me about yourself" with feedback
- [ ] Review interview prep materials and update

{If FIT-TIMING GAP:}
- [ ] Map 3-5 competitor companies with similar roles
- [ ] Set calendar reminder to re-engage {company} in {timeframe}
- [ ] Review targeting criteria - any adjustments needed?

**Regardless of Diagnosis:**
- [ ] Debrief with trusted person (mentor, friend, coach)
- [ ] Review job search metrics - are you on track?
- [ ] Queue next applications (maintain momentum)

### Ongoing (Next 2-4 Weeks)

**Development:**
{Specific skill or story development based on diagnosis}
- {Action 1 with timeline}
- {Action 2 with timeline}

**Application Strategy:**
- {Adjustment 1 based on learnings}
- {Adjustment 2 based on learnings}

**Relationship Maintenance:**
- {Contact 1} - {How to stay connected}
- {Contact 2} - {How to stay connected}

---

## 8. Plan Updates Required

### If You Have a 3-Month Job Search Plan:

**Week {X} Adjustments:**
- {Specific task to add/modify}
- {Milestone to adjust}

**Monthly Goal Check:**
- {Any goal adjustments based on this data point}

### If You Have Interview Prep Materials:

**STAR Stories to Update:**
- {Story title}: {What to change/strengthen}
- {New story needed}: {Topic and source from CV}

**Talking Points to Add:**
- {New talking point to address concern}

### If You Have an Application Strategy:

**Targeting Adjustments:**
- {Any changes to company/role targeting}

**Process Adjustments:**
- {Any changes to how you approach applications}

---

## 9. Wellbeing Check

### Where You Are

**Rejection Count:** {X} in this search
**Typical Range:** 6-10 rejections before offer is common *(approximate; varies by industry, level, and market conditions)*

{If low count:}
> You're within normal range. Each rejection is a data point, not a verdict.

{If high count:}
> You've had more than typical rejections. This is genuinely hard. Let's check if patterns suggest adjustments, and make sure you're protecting your energy.

### Energy Management

**Current Risk Level:** {Low / Medium / Watch}

**Signs to Monitor:**
- [ ] Withdrawing from applications or people
- [ ] Sleep or appetite changes
- [ ] Extended periods of low motivation
- [ ] Self-worth statements ("I'm not good enough")

**If Experiencing These:**
Talk to someone - friend, family member, or professional support. Job search struggles are common and support helps.

### Sustainability Practices

**This Week:**
- {One non-job-search activity scheduled}
- {One social connection planned}
- {Exercise or movement included}

**Quality Over Quantity:**
- Better to do 5 strong applications than 15 weak ones
- Take days off from searching - it's sustainable, not lazy

---

## 10. Forward Momentum

### Your Concrete Next Steps

| Action | Timeline | Success Looks Like |
|--------|----------|-------------------|
| {Action 1} | {By when} | {Specific outcome} |
| {Action 2} | {By when} | {Specific outcome} |
| {Action 3} | {By when} | {Specific outcome} |
| {Action 4} | {By when} | {Specific outcome} |
| {Action 5} | {By when} | {Specific outcome} |

### Companies to Target Next

Based on this experience:
| Company | Similar Role? | Why Target | Status |
|---------|--------------|------------|--------|
| {Company 1} | {Role type} | {Reason} | {To research / To apply} |
| {Company 2} | {Role type} | {Reason} | {To research / To apply} |
| {Company 3} | {Role type} | {Reason} | {To research / To apply} |

### Re-engagement Plan for {Company}

{If this company still matters to you:}
- **Timeline:** Consider re-applying in {6-12 months}
- **Stay Visible:** {How - content engagement, mutual connections}
- **What Would Change:** {What you'd do differently next time}

---

## 11. Feedback Request Template

**If You Want to Request Feedback:**

**Email (Send Within 72 Hours):**

Subject: Thank you - {Role Title} interview feedback request

Dear {Name},

Thank you for letting me know about the {Role Title} decision. While I'm disappointed, I appreciated the opportunity to learn about {Company} and the role.

If you have a moment, I would find it genuinely helpful to understand any areas where I could strengthen my candidacy for similar roles in future. Even brief feedback would be valuable for my development.

Thank you again for your time and consideration throughout the process.

Best regards,
{Your Name}

**Notes:**
- Send within 72 hours while fresh
- Don't send multiple follow-ups
- Accept that many won't respond (that's normal)
- Don't argue with any feedback received

---

## 12. Pattern Tracking

{If multiple rejections, track patterns:}

### Rejection History (This Search)

| # | Company | Role | Stage Reached | Diagnosis | Key Learning |
|---|---------|------|---------------|-----------|--------------|
| 1 | {Company} | {Role} | {Stage} | {S/S/F} | {Learning} |
| 2 | {Company} | {Role} | {Stage} | {S/S/F} | {Learning} |
| {This} | {Company} | {Role} | {Stage} | {S/S/F} | {Learning} |

### Emerging Patterns

**Stage Conversion:**
- Application → Screen: {X/Y} = {%}
- Screen → HM: {X/Y} = {%}
- HM → Technical: {X/Y} = {%}
- Technical → Final: {X/Y} = {%}
- Final → Offer: {X/Y} = {%}

**Bottleneck:** {Stage where most rejections occur}
**Implication:** {What this suggests}

**Recurring Themes:**
- {Theme 1 across multiple rejections}
- {Theme 2 across multiple rejections}

**Progress Indicators:**
- {Are you getting further in processes?}
- {Is feedback improving?}
- {Are learnings being applied?}

---

## Summary

### Key Takeaway
{One sentence summary of what this rejection teaches}

### Primary Action
{The single most important thing to do}

### Mindset Reminder
> This rejection reflects alignment at a single moment in time. Your capabilities haven't changed. Your track record hasn't changed. What's changed is you have more data about what works and what to adjust.

---

*Generated using Career Helper skill by Paul Bratcher ([LinkedIn](https://www.linkedin.com/in/paul-bratcher/) | [GitHub](https://github.com/Zal4DW/career-helper)). Found this helpful? Share your experience or suggest improvements on GitHub.*
