# LinkedIn Profile Updates: {User Name}

**Optimized for:** {Target Role} at {Company Name}
**Generated:** {Date}
**Priority:** Complete these updates before applying

---

## Critical: RSC API Consistency

Many ATS systems pull LinkedIn data via the Recruiter System Connect (RSC) API. This API exports limited fields, so consistency between your CV and LinkedIn is critical.

**Fields Exported by RSC API:**
- Headline
- Top 3 skills only
- About section
- Two most recent experience entries only

**Action Required:** Update these fields first to match your optimized CV exactly.

---

## 1. Headline Update

**Current Headline:**
```
{Current headline if known, otherwise [PASTE CURRENT HEADLINE]}
```

**Recommended Headline (220 character limit):**
```
{New headline that includes: target title, core domain, 2 high-value keywords}
```

**Why This Works:**
{Brief explanation of keyword choices and positioning}

---

## 2. About Section Rewrite

**Current About:**
```
{Current about section if known, otherwise [PASTE CURRENT ABOUT]}
```

**Recommended About:**

{Paragraph 1: Professional summary that mirrors CV Profile section, 2-3 sentences}

{Paragraph 2: Key achievements with quantified impact, 3-4 sentences. Include same phrasing as CV bullets}

{Paragraph 3: Current focus and what you bring to target roles, 2-3 sentences}

**Quantified Impact Lines (must match CV exactly):**
- {Impact statement 1 with metric}
- {Impact statement 2 with metric}
- {Impact statement 3 with metric}

**Character Count:** {X} of 2600 character limit

---

## 3. Skills Section Reorder

**Critical:** The RSC API exports only your top 3 skills. These must be your highest-value keywords.

**Recommended Top 3 Skills (in order):**
1. {Skill 1 from keyword list}
2. {Skill 2 from keyword list}
3. {Skill 3 from keyword list}

**How to Reorder:**
1. Go to Skills section on your profile
2. Click pencil/edit icon
3. Drag these three skills to positions 1, 2, 3
4. Save changes

**Additional Skills to Add (if not present):**
- {Skill 4}
- {Skill 5}
- {Skill 6}
- {Skill 7}
- {Skill 8}

---

## 4. Experience Section - Two Most Recent Roles

The RSC API exports only your two most recent positions. These MUST match your CV exactly.

### {Most Recent Company} | {Job Title}
**Dates:** {Month YYYY} - {Present or Month YYYY}

**Bullet Points (must match CV exactly):**
- {Bullet 1 - copy from optimized CV}
- {Bullet 2 - copy from optimized CV}
- {Bullet 3 - copy from optimized CV}
- {Bullet 4 - copy from optimized CV}

### {Second Most Recent Company} | {Job Title}
**Dates:** {Month YYYY} - {Month YYYY}

**Bullet Points (must match CV exactly):**
- {Bullet 1 - copy from optimized CV}
- {Bullet 2 - copy from optimized CV}
- {Bullet 3 - copy from optimized CV}

---

## 5. Featured Section (Optional but Recommended)

Add one piece of content that reinforces a high-impact concept from your target role.

**Recommendation:**
- **Type:** {Article/Post/Project/Media}
- **Title:** {Title}
- **Description:** {Brief description that reinforces {Concept X}}
- **Link:** {URL if applicable}

---

## API Consistency Verification Checklist

Before applying, verify exact matches between LinkedIn and CV:

**Employer Names:**
- [ ] Most recent employer name matches exactly
- [ ] Second most recent employer name matches exactly

**Job Titles:**
- [ ] Most recent job title matches exactly
- [ ] Second most recent job title matches exactly

**Dates:**
- [ ] Most recent role dates match exactly (same format: Month YYYY)
- [ ] Second most recent role dates match exactly

**Key Metrics:**
- [ ] Quantified achievements use same numbers in both places
- [ ] Phrasing of impact statements is identical

**Skills:**
- [ ] Top 3 skills are highest-value keywords
- [ ] All key skills from CV are present in LinkedIn skills list

---

## Additional Profile Optimization

### Profile Photo
- [ ] Professional headshot, recent (within 2 years)
- [ ] Clear face visibility, appropriate attire for industry
- [ ] Neutral background

### Banner Image
- [ ] Custom banner that reflects industry/expertise
- [ ] Professional quality (not default LinkedIn banner)

### Contact Information
- [ ] Email address visible
- [ ] Phone number visible
- [ ] Website/portfolio link if relevant

### Custom URL
- [ ] Set to: linkedin.com/in/{firstname-lastname} or similar professional format

### Open to Work Settings
- [ ] "Open to Work" flag enabled (visible to recruiters only if preferred)
- [ ] Job titles specified: {Target role title and variations}
- [ ] Locations specified: {Target locations}

---

## Timeline for Updates

**Before Applying:**
1. Update headline (5 minutes)
2. Rewrite About section (15 minutes)
3. Reorder top 3 skills (2 minutes)
4. Update two most recent experience entries (20 minutes)

**Within 48 Hours:**
5. Add Featured content (10 minutes)
6. Verify API consistency checklist (10 minutes)
7. Complete additional profile optimization (15 minutes)

**Total Time Investment:** ~75 minutes for complete optimization

---

## Testing Your Updates

**After making changes:**

1. **Export Test:** Use a LinkedIn data export to verify fields
   - Settings → Data Privacy → Get a copy of your data
   - Review what appears in export file

2. **View As Test:** View profile as hiring manager would see it
   - "View profile as" button on your profile
   - Check what's most prominent

3. **Mobile Test:** View on mobile app
   - Ensure formatting looks clean
   - Verify headline and about section are compelling

4. **Search Test:** Search for yourself
   - Use target keywords in LinkedIn search
   - See if your profile appears in results

---

## Maintenance Reminders

**Keep Updated:**
- CV and LinkedIn must remain synchronized
- Any changes to CV require matching LinkedIn updates
- Review and refresh every 3-6 months even if not actively job hunting

**Monitor Engagement:**
- Track profile views after updates (should increase)
- Note which keywords drive recruiter searches (appears in "Who viewed your profile")
- Adjust based on which content gets engagement

---

*Generated using Career Helper skill by Paul Bratcher ([LinkedIn](https://www.linkedin.com/in/paul-bratcher/) | [GitHub](https://github.com/Zal4DW/career-helper)). Found this helpful? Share your success story or suggest improvements on GitHub!*
