# NED Briefing Source Content

**Source:** Paul Bratcher NED Briefing Presentation
**Author:** Paul Bratcher, Partner at Prosper AI Consulting

---

## About the Author

Partner at Prosper AI Consulting with 30 years experience as a digital change leader across a range of companies, from startup to FTSE 100. Roles include CIO, CTO, CMO.

---

## Introduction

This is not a training course. It's a strategic briefing for board members on AI governance.

---

## Adoption Trends

### 2023-2025 Shift

2025 has seen a move from almost all "thinking about" to a significant amount of "starting".

UK Business is significantly behind USA in AI adoption.

### Key Statistics

- **World Economic Forum:** 20% of all knowledge work will be significantly augmented by 2030
- **HMRC, NHS, Scotland Yard:** Each have 30,000+ user Copilot rollouts, reporting 43 minutes saved effort per user per day

### The Widening Gap

Companies starting later are realising that they now won't catch those who started earlier.

---

## Changing Skills Landscape

### Re-valuation of Skills

Emergence of demand for:
- AI Skills
- Soft Skills
- Systems Thinking
- Critical Thinking
- Curiosity

---

## Common Myths Debunked

### "AI won't take your job"

The claim: "AI won't take your job, but someone using AI will."

**Reality:** Fundamentally not true. AI will take some jobs (up to 30% in fact).

### "Modernising workflows..."

The claim: "Modernising workflows to be agentic isn't enough, you need to redefine your business structure for the AI age."

**Reality:** What does that even mean? Be sceptical of vague transformation claims.

### "I can tell it's AI"

The claim: "My job is safe, I can tell it's AI."

**Clarification:** You can tell when it's "bad AI". Good AI output is increasingly indistinguishable.

---

## AI Capabilities and Pace

Artificial intelligence main vendors are continuing to outpace capable deployment of that technology by businesses.

Many problems from a year ago are either now solved enough for practical usage, or workarounds have been established.

---

## Avatars and Deepfakes

"Deepfake" and text-to-avatar capabilities are now being used in a number of countries as news casters.

---

## Agentic AI

### Next Generation Workflow

New and emerging workflow solutions based around "agentic" and "AI code-based flows".

### Market Size

- £6bn in 2025
- £90bn by 2030

### Impact on Knowledge Work

Agentic research can, has, and will replace vast amounts of entry-level data work: junior lawyers, market research analysts, accountants.

---

## The Wall: Common Barriers

The usual suspects blocking AI success:
- Outcomes (unclear)
- Data (poor quality)
- Change (resistance)
- Communications (inadequate)
- People (skills gaps)

**Note:** Technology is NOT typically the barrier.

---

## The 70:20:10 Recipe for Success

### Three Approaches Compared

| Approach | Expected ROI |
|:---------|:-------------|
| "Buy everyone a license" strategy | Little to no identifiable ROI |
| "Reinvent everything using AI" team | 20-40% ROI within a year |
| Clear goals and outcome measures | 30-70% ROI within a year |

**Recommendation:** Focus on clear goals and outcome measures.

---

## Key Reminders for NEDs

You need to be considering:
- **AI Risk** - What could go wrong?
- **Talent** - Do we have the skills?
- **Change** - How will we manage adoption?

---

## Strategic Principles

### Outcome Driven

Focus on outcomes over vanity measures.

### Technology Centric

Develop how to move into, and out of, changing technology as a key business concept.

---

## Prosper AI Consulting Services

### AI Strategy

Don't know where to start? We can help you work that out.

### Fractional Leadership

Broad "grey hair" expertise when you need it, with deep relevant skills. Subscription service available.

### Delivery

Forward-deployed engineering approach to build systems and solutions with you.

### Short Hands-on Projects

We can run a "hackathon" or innovation day with your team to elevate your team's AI activities, including software delivery teams.

### C-Suite Retreat

C-Suite "AI Retreat": a two-day away-from-the-office event to help the leadership team fast-track their understanding of AI and ideate on strategic change. Discuss what being an AI-native firm means in practical terms.

---

## Contact

**Paul Bratcher**
Partner, Prosper AI Consulting

- LinkedIn: https://www.linkedin.com/in/paul-bratcher/
- Phone: +44 7894 701014
- Email: paul.bratcher@prosperconsulting.ai

---
