# AI Industry Reference Statistics

Evidence-based data for board discussions and challenge questions. Sources verified from industry research 2024-2025.

---

## Productivity & ROI

### Time Savings
| Metric | Value | Source |
|:-------|:-----:|:-------|
| Average task time reduction with AI | **80%** | Anthropic 2025 |
| Median time savings per conversation | **84%** | Anthropic 2025 |
| Hours saved per year with AI training | **122 hours** | Google/Public First 2025 |
| Teacher time saved per week (education sector) | **2.9 hours** | Google/Public First 2025 |

### Return on Investment
| Investment Type | ROI | Source |
|:----------------|:---:|:-------|
| AI training programmes | **10:1** | Google/Public First 2025 |
| Traditional skills programmes | **1:2** | Google/Public First 2025 |
| Outcome-focused AI (clear goals) | **30-70%** within 1 year | Paul Bratcher NED Briefing |
| "Reinvent everything" approach | **20-40%** within 1 year | Paul Bratcher NED Briefing |
| "Buy everyone a license" strategy | **Little to no ROI** | Paul Bratcher NED Briefing |
| Microsoft Copilot (enterprise) | **132-353%** | Microsoft 2025 |

### Wage Impact
| Metric | Value | Source |
|:-------|:-----:|:-------|
| Median task labour cost | **$54** per AI conversation | Anthropic 2025 |
| Higher-wage tasks correlation | **r=0.8** with task complexity | Anthropic 2025 |
| Potential US productivity growth | **+1.8%** annually (doubling current rate) | Anthropic 2025 |

---

## UK Adoption Landscape

### Current State (2025)
| Metric | Value | Source |
|:-------|:-----:|:-------|
| UK workers using generative AI at work | **34%** | Google/Public First 2025 |
| Workers NOT using AI at work | **66%** | Google/Public First 2025 |
| AI users using it daily | **44%** | Google/Public First 2025 |
| Adoption that is worker-led (not employer-directed) | **71%** | Google/Public First 2025 |

### Adoption Gap
| Demographic | AI Usage Likelihood | Source |
|:------------|:-------------------:|:-------|
| Men under 35 | **Baseline** | Google/Public First 2025 |
| Women over 55 | **4x less likely** | Google/Public First 2025 |

### Training Impact
| Metric | Before Training | After Training | Source |
|:-------|:---------------:|:--------------:|:-------|
| Weekly AI usage (all cohorts) | 37% | **71%** | Google/Public First 2025 |
| Daily usage (education) | 19% | **47%** | Google/Public First 2025 |
| Women over 55 weekly usage | 17% | **56%** | Google/Public First 2025 |

---

## Enterprise AI Maturity

### Performance Correlation
| Metric | Value | Source |
|:-------|:-----:|:-------|
| Organisations excelling in 3 AI areas → top performance | **32x more likely** | IBM 2024 |
| Investment focused on improving existing processes | **78%** | IBM 2024 |
| Agree new operating model needed for agentic AI | **78%** | IBM 2024 |
| Cite inadequate skills as barrier | **47%** | IBM 2024 |

### EMEA AI Confidence (IBM 2025)
| Metric | Today | By 2027 |
|:-------|:-----:|:-------:|
| AI agents take independent action | 24% | **67%** |
| Autonomous decision-making in workflows | 28% | **57%** |
| AI automating innovation processes | 19% | **48%** |

### Sector Variation (EMEA)
| Sector | Significant AI Productivity Gains | Achieving ROI Goals Now |
|:-------|:---------------------------------:|:-----------------------:|
| Banking & Financial Services | **72%** | **26%** |
| Energy & Utilities | **70%** | **26%** |
| EMEA Average | **66%** | **20%** |
| Public Sector | **55%** | **13%** |

---

## AI-First vs Traditional

### Operating Model Comparison
| Domain | Traditional | AI-First |
|:-------|:------------|:---------|
| Growth model | Linear (headcount) | Exponential (automation) |
| Process focus | Optimising existing | Embedding intelligence |
| Change response | Reactive | Proactive systems that learn |
| Revenue per employee | Standard | **>$2M** in top AI-native startups |

### Pilot Purgatory Indicators
| Warning Sign | Impact |
|:-------------|:-------|
| Scattered experiments | Marginal gains only |
| Technology-first thinking | No business outcome focus |
| Pilots without adoption metrics | "Governance theatre" |

Source: McKinsey AI-First Playbook 2025

---

## Public Sector Challenges

### Education Sector (UK)
| Metric | Value | Source |
|:-------|:-----:|:-------|
| Teachers saying workload unmanageable | **49%** | Google/Public First 2025 |
| Teachers working outside contracted hours | **77%** | Google/Public First 2025 |
| Teachers considering leaving within 1 year | **34%** | Google/Public First 2025 |
| Of those, citing workload as reason | **90%** | Google/Public First 2025 |
| Never used generative AI at work (baseline) | **51%** | Google/Public First 2025 |

### Public Sector Barriers (EMEA)
| Barrier | % Citing | Source |
|:--------|:--------:|:-------|
| Inadequate data infrastructure | **70%** | IBM EMEA 2025 |
| Budget limitations | **68%** | IBM EMEA 2025 |
| Talent/expertise shortage | **66%** | IBM EMEA 2025 |
| Scaling beyond pilots | **66%** | IBM EMEA 2025 |
| Internal misalignment on AI strategy | **63%** | IBM EMEA 2025 |

---

## AI Idea Generation

### Diversity Problem (Wharton Research)
| Metric | Human Groups | Basic GPT-4 | Chain-of-Thought |
|:-------|:------------:|:-----------:|:----------------:|
| Cosine similarity (lower = more diverse) | **0.243** | 0.255-0.432 | **~0.243** |
| Unique ideas generated | Baseline | 3,700 | **4,700** |

**Key finding:** Chain-of-Thought prompting achieves near-human idea diversity. Default prompts produce homogeneous ideas.

Source: Wharton SSRN 2024

---

## Quotable Statistics for Board Use

### The Headline Numbers
- **80%** task time reduction with AI assistance
- **10:1** ROI on AI training vs 1:2 for traditional skills
- **32x** performance advantage for AI-mature organisations
- **92%** EMEA leaders confident in AI agent ROI within 2 years
- **$3.5B** IBM's productivity gains from AI in 2 years

### The Warning Numbers
- **78%** AI investment focused on process improvement, not transformation
- **66%** UK workers NOT using AI at work
- **70%** public sector cite data infrastructure as barrier
- **<1%** override rate indicates rubber-stamping (HITL failure)
- **>50%** technology spend in business case = red flag

---

## Key Insights for NEDs

> "The single biggest reason enterprise AI fails is that companies still treat it as a tool instead of a general-purpose technology."
> — McKinsey AI-First Playbook 2025

> "Nobody needs trillion-parameter, generic models. They need efficient, cost-effective AI tailored for use cases that matter."
> — Ana Paula Assis, IBM

> "Companies starting later are realising they now won't catch those who started earlier."
> — Paul Bratcher, NED Briefing 2024

> "Permission to prompt: Workers need explicit permission and clear policies. Many felt using AI was 'cheating' without institutional endorsement."
> — Google/Public First AI Works 2025

---

---

## Workforce Transformation & Job Displacement

### WEF Future of Jobs Report 2025

| Metric | Value | Source |
|:-------|:-----:|:-------|
| Jobs affected by structural transformation (2025-2030) | **22%** of total jobs | [WEF Future of Jobs 2025](https://www.weforum.org/publications/the-future-of-jobs-report-2025/digest/) |
| New jobs created | **170 million** (14% of total) | WEF 2025 |
| Jobs displaced | **92 million** (8% of total) | WEF 2025 |
| Net job growth | **78 million** (7% of total) | WEF 2025 |
| Businesses expecting AI transformation by 2030 | **86%** | WEF 2025 |
| Business leaders expecting AI/GenAI to transform their org | **60%** | WEF 2025 |

### AI-Driven Job Creation vs Displacement

| Category | Jobs Created | Jobs Displaced | Source |
|:---------|:------------:|:--------------:|:-------|
| AI and information-processing technologies | **+19 million** | **-9 million** | WEF 2025 |
| Net impact | **+10 million** | - | WEF 2025 |

### Employer Response to Transformation

| Strategy | % of Employers | Source |
|:---------|:--------------:|:-------|
| Prioritise upskilling workforce | **85%** | WEF 2025 |
| Hire staff with new skills | **70%** | WEF 2025 |
| Transition staff from declining to growing roles | **50%** | WEF 2025 |
| Reduce staff as skills become less relevant | **40%** | WEF 2025 |

---

## The Skills Crisis

### WEF Skills Projections

| Metric | Value | Source |
|:-------|:-----:|:-------|
| Skills needed for work expected to change by 2030 | **70%** | WEF 2025 |
| Workers needing training by 2030 (if workforce was 100 people) | **59** | WEF 2025 |
| Could be upskilled in current roles | **29** | WEF 2025 |
| Could be upskilled and redeployed | **19** | WEF 2025 |
| Unlikely to receive needed reskilling | **11** (employment at risk) | WEF 2025 |

### Fastest Growing Skills (2025-2030)

1. AI and big data
2. Networks and cybersecurity
3. Technological literacy
4. Creative thinking
5. Resilience, flexibility and agility
6. Curiosity and lifelong learning

Source: [WEF Future of Jobs 2025](https://www.weforum.org/stories/2025/01/future-of-jobs-report-2025-jobs-of-the-future-and-the-skills-you-need-to-get-them/)

### AI Talent Demand

| Hiring Focus | % of Employers | Source |
|:-------------|:--------------:|:-------|
| Recruiting talent skilled in AI tool design | **69%** | WEF 2025 |
| Hiring individuals with skills to work with AI | **62%** | WEF 2025 |

---

## Organisational Change Barriers

### Primary Barriers to Transformation (2025-2030)

| Barrier | % Citing | Trend | Source |
|:--------|:--------:|:-----:|:-------|
| **Skills gaps in labour market** | **63%** | ↑ from 60% (2023) | WEF 2025 |
| **Organisational culture and resistance to change** | **46%** | New prominence | WEF 2025 |

**Key insight:** The biggest barrier is not technology - it's people and culture.

### Organisational Response Patterns

| Strategy | % of Organisations | Source |
|:---------|:------------------:|:-------|
| Reorient business models toward AI-driven opportunities | **49%** | WEF 2025 |
| Transition employees from AI-disrupted roles | **47%** | WEF 2025 |

---

## The Frontier Firm Model

### Microsoft's Vision for AI-Era Organisations

> "The future belongs to Frontier Firms - human-led, agent-operated organisations that buy intelligence like electricity, help their employees put it to work to generate value, and compound it like interest."
> — Kathleen Hogan, EVP Chief Strategy and Transformation Officer, Microsoft

### Five Capabilities of Frontier Firms

| Capability | Description |
|:-----------|:------------|
| Make knowledge work visible | Expose how actual work happens so AI opportunities are concrete |
| Define risk boundaries | Ensure trust and guardrails in place before scaling |
| Design the AI solution set | Choose right mix of no-code, low-code, and pro-code |
| Redesign roles for sustainability | Update jobs and team structures so new ways of working stick |
| Instill continuous experimentation | Build culture to keep pace with evolving AI |

Source: Microsoft "Becoming a Frontier Firm" 2024

### Critical Transformation Insight

> "Redesigning with AI doesn't begin with technology. It begins with understanding how people actually work. You can't transform what you can't see."
> — Katy George, CVP Workforce Transformation, Microsoft

> "This is not an IT transformation or a product launch - it's a business transformation. Business leaders must be clear about what objectives really matter."
> — Microsoft Frontier Firm Guide

---

## The End of Digitalisation, Start of AI Era

### Paradigm Shift

| Era | Focus | Organisational Model |
|:----|:------|:---------------------|
| **Digitalisation (1990s-2020s)** | Process automation, digital channels | Traditional hierarchy, efficiency focus |
| **AI Era (2020s-onwards)** | Intelligence augmentation, agentic systems | Human-led, agent-operated, continuous adaptation |

### What This Means for Boards

| Old Assumption | New Reality |
|:---------------|:------------|
| Technology projects have end dates | AI capability requires continuous evolution |
| IT department owns digital transformation | Business transformation owned by whole organisation |
| Training is a one-time event | Continuous learning is mandatory (70% skills change) |
| Headcount drives capacity | Intelligence drives capacity |
| Change management is a phase | Change is permanent state |

### Board Questions for the AI Era

1. Are we treating AI as a project or a permanent capability?
2. What percentage of our workforce will need reskilling by 2030?
3. Is our culture ready for continuous change?
4. Are we transitioning disrupted employees or simply reducing headcount?
5. How are we measuring AI maturity beyond pilot counts?

---

## Job Growth and Decline by Role (WEF 2025)

### Fastest Growing Jobs (% growth, 2025-2030)

| Rank | Role | Growth Driver |
|:----:|:-----|:--------------|
| 1 | Big Data Specialists | AI/Analytics demand |
| 2 | FinTech Engineers | Digital financial services |
| 3 | AI and Machine Learning Specialists | AI implementation |
| 4 | Software and Applications Developers | Digital transformation |
| 5 | Security Management Specialists | Cyber risk |
| 6 | Data Warehousing Specialists | Data infrastructure |
| 7 | Autonomous and Electric Vehicle Specialists | Green transition |
| 8 | UI and UX Designers | Digital experience |
| 9 | Light Truck or Delivery Services Drivers | E-commerce growth |
| 10 | Internet of Things Specialists | Connected systems |

### Fastest Declining Jobs (% decline, 2025-2030)

| Rank | Role | Decline Driver |
|:----:|:-----|:---------------|
| 1 | Cashiers and Ticket Clerks | Automation/self-service |
| 2 | Administrative Assistants and Executive Secretaries | AI assistants |
| 3 | Printing Workers | Digital media |
| 4 | Accountants and Auditors | AI automation |
| 5 | Material Recording and Stock Keeping Clerks | Warehouse automation |
| 6 | General and Operations Managers | AI decision support |
| 7 | Client Information Workers | Chatbots/AI |
| 8 | Business Services and Admin Managers | Process automation |
| 9 | Door-To-Door Sales, News and Street Vendors | Digital channels |
| 10 | Electronics and Telecommunications Installers | Technology shifts |

### Largest Absolute Job Growth

| Role | Net New Jobs |
|:-----|:------------:|
| Farmworkers, Labourers, Agricultural Workers | **+35 million** |
| Delivery Drivers | Large growth |
| Building Construction Workers | Large growth |
| Nursing Professionals | Significant growth |
| Software and Applications Developers | Significant growth |

**NED Challenge:** When evaluating AI initiatives, cross-reference impacted roles against these lists. Investing in automation of already-declining roles may be less valuable than upskilling for growing roles.

---

## AI Skills by Industry Sector (WEF 2025)

### Industries Where AI/Big Data is Core Skill

| Industry | % Considering Core |
|:---------|:------------------:|
| Automotive and Aerospace | **100%** |
| Telecommunications | **100%** |
| Professional Services | **98%** |
| Information and Technology Services | **97%** |
| Insurance and Pensions Management | **97%** |
| Financial Services and Capital Markets | **95%** |
| Supply Chain and Transportation | **94%** |
| Medical and Healthcare Services | **92%** |
| Government and Public Sector | **90%** |
| Energy Technology and Utilities | **90%** |

### Industries Prioritising Technological Literacy

| Industry | % Considering Core |
|:---------|:------------------:|
| Automotive and Aerospace | **84%** |
| Financial Services and Capital Markets | **84%** |
| Medical and Healthcare Services | **81%** |
| Insurance and Pensions Management | **81%** |
| Education and Training | **76%** |

### Industries Prioritising Environmental Stewardship

| Industry | % Considering Core |
|:---------|:------------------:|
| Oil and Gas | **80%** |
| Chemical and Advanced Materials | **75%** |
| Agriculture, Forestry, and Fishing | **71%** |
| Automotive and Aerospace | **70%** |
| Mining and Metals | **68%** |

**NED Challenge:** Compare your organisation's AI skill investment against industry benchmarks. If 100% of automotive/aerospace considers AI core but your firm doesn't, that's a strategic gap.

---

## Sector-Specific Insights (WEF 2025)

### Insurance and Pensions Management
- **83%** prioritise curiosity and lifelong learning (vs 50% global average)
- **94%** prioritise resilience, flexibility and agility (vs 67% global average)
- **86%** prioritise creative thinking (highest of all sectors)

### Government and Public Sector
- **90%** consider AI and big data as core skill
- Double the global average for environmental stewardship emphasis
- Lowest achieving ROI goals now (**13%** vs 20% EMEA average)

### Telecommunications
- **100%** consider AI and big data as core skill
- 2x global average for design/UX, cybersecurity, and programming
- **79%** prioritise resilience, flexibility and agility

### Mining and Metals
- **50%** prioritise environmental stewardship (2.5x global average)
- Higher emphasis on manual dexterity and precision
- **68%** prioritise talent management

**Board Application:** Use sector benchmarks to challenge whether AI proposals align with industry-wide skill priorities. A proposal that ignores sector-specific requirements may be poorly conceived.

---

## Source Documents

Full reports available in `.claude/.odta-method-reference-docs/useful-casestudies-whitepapers-reference-reports/`:

- `Estimating-AI-productivity-gains-from-Claude-conversations.md` - Anthropic
- `ai_works_2025_en.md` - Google/Public First
- `IBM_Agentic_AI_s_strategic_ascent.md` - IBM
- `IBM EMEA Report - The Race for AI.md` - IBM
- `Playbook_How_to_become_AI_first.md` - McKinsey
- `ssrn-4708466.md` - Wharton (AI Idea Diversity)
- `copilot-value-guide-ebook-jan-2025.md` - Microsoft
- `Becoming_a_Frontier_Firm.md` - Microsoft
- `WEF-Future-of-Jobs-2025-distilled.md` - WEF (distilled reference)

### External Sources

- [WEF Future of Jobs Report 2025](https://www.weforum.org/publications/the-future-of-jobs-report-2025/digest/)
- [WEF Jobs of Tomorrow 2025](https://www.weforum.org/publications/jobs-of-tomorrow-technology-and-the-future-of-the-world-s-largest-workforces/)
- [WEF Skills and Workforce Strategies](https://www.weforum.org/publications/the-future-of-jobs-report-2025/in-full/4-workforce-strategies/)
