# NED AI Literacy Guide

Essential AI concepts for board-level engagement without technical depth.

---

## What NEDs Need to Know

### Essential Concepts

| Concept | Plain English | Why It Matters for Boards |
|:--------|:-------------|:--------------------------|
| **Large Language Model (LLM)** | AI trained on vast text to generate human-like responses | Foundation of most current AI tools; understand capabilities and limitations |
| **Hallucination** | AI generating plausible but false information | Critical risk for any AI producing reports, advice, or decisions |
| **Training data** | The information AI learned from | Determines what AI knows and its biases; data quality drives output quality |
| **Fine-tuning** | Customising an AI model for specific tasks | Relevant to vendor claims about "bespoke" AI solutions |
| **Prompt engineering** | Crafting instructions to get better AI outputs | Staff skill that drives AI effectiveness; part of the 70:20:10 people investment |
| **Bias** | Systematic errors reflecting training data patterns | Legal, ethical, and reputational risk; particularly in HR and customer-facing AI |
| **Explainability** | Ability to understand why AI produced a specific output | Regulatory requirement for high-impact decisions; essential for accountability |
| **Retrieval-Augmented Generation (RAG)** | AI that looks up information before answering | Reduces hallucination; common in enterprise AI; still not foolproof |

### What NEDs Do NOT Need to Know

- Neural network architecture details
- Mathematical foundations (transformers, attention mechanisms)
- Programming or technical implementation
- Specific vendor technology stacks
- Model training procedures

---

## Key Questions to Sound Credible

Instead of demonstrating technical knowledge, ask these:

### About AI Proposals

- "What specific business outcome does this AI support?"
- "How will we measure whether it is working?"
- "What happens when the AI gets it wrong?"
- "What is the investment split between people, process, and technology?"

### About AI Risks

- "How do we know the AI is not making biased decisions?"
- "Can we explain AI decisions to affected individuals?"
- "What is our fallback if the AI system fails?"
- "Have we tested this with real users, not just demonstrations?"

### About AI Vendors

- "How does the vendor handle our data?"
- "What happens to our data if we switch vendors?"
- "Where is the evidence that this works in organisations like ours?"
- "What are the ongoing costs beyond the initial licence?"

---

## Common Misconceptions

| Misconception | Reality |
|:--------------|:--------|
| "AI understands our business" | AI processes patterns in data; it has no understanding |
| "AI will replace jobs" | AI changes tasks within jobs; replacement is rare and slow |
| "AI is objective" | AI reflects biases in its training data |
| "More AI is always better" | AI without clear outcomes wastes money |
| "AI is a one-off investment" | AI requires ongoing maintenance, training, and governance |
| "AI makes decisions" | AI makes predictions; humans should make decisions |

---

## Ongoing Learning

### Recommended Sources

| Source | Type | Time Commitment |
|:-------|:-----|:----------------|
| Board Intelligence AI briefings | Newsletter | 5 min/week |
| FT AI coverage | News | 10 min/week |
| ICO AI guidance updates | Regulatory | As published |
| Alan Turing Institute reports | Research | Quarterly review |

### Board Development

- Annual AI briefing from CTO/CDO (require it)
- Site visit to see AI in operation (not just slides)
- External expert session annually
- Peer NED discussion on AI governance

---

*NED AI Literacy Guide | NED AI Helper | Prosper AI Consulting, UK*
