# NED AI Helper Capabilities Overview

What this skill can do for Non-Executive Directors, Governors, and Trustees.

---

## Core Purpose

Help board members exercise effective AI governance oversight without requiring technical expertise. The skill provides frameworks, questions, and guidance for:

- **Challenging** AI proposals and business cases
- **Assessing** AI risks in board-familiar formats
- **Structuring** governance for AI oversight
- **Understanding** duties and liabilities in AI context
- **Building** AI literacy for credible engagement

---

## Ten Capabilities

### 1. Strategic Challenge Framework
Generate targeted questions to challenge AI proposals at board level.

**Use when:** Reviewing AI business cases, strategy presentations, vendor proposals

**Produces:** 35+ categorised questions covering strategic fit, business case validity, risk, implementation readiness, and governance

### 2. AI Risk Register Entry
Create board-level risk documentation for AI use cases.

**Use when:** Documenting new AI deployments, updating risk registers, committee reporting

**Produces:** Structured risk entry with impact classification, delegation level, HITL requirements, escalation triggers

### 3. Impact Classification Assessment
Determine appropriate oversight level for AI use cases using the Canada AIA four-tier model.

**Use when:** Evaluating new AI use cases, determining governance requirements

**Produces:** Impact level (I-IV) with rationale, governance requirements, human oversight specifications

### 4. Governance Structure Options
Analyse options for structuring AI oversight at board level.

**Use when:** Setting up AI governance, reviewing committee structures

**Produces:** Pros/cons analysis of dedicated AI committee vs Risk/Audit integration vs full board approach

### 5. Fiduciary Duty Mapping
Translate existing director/trustee duties to AI context.

**Use when:** Understanding personal obligations, liability exposure, competence requirements

**Produces:** Duty translations (Companies Act, Charities Act), liability considerations, conflict guidance

### 6. Change Readiness Assessment
Evaluate whether AI programmes are structured for success using the 70:20:10 framework.

**Use when:** Reviewing business cases, challenging implementation plans

**Produces:** Investment balance analysis, change programme gap identification, adoption vs deployment metrics

### 7. HITL Design Review
Assess whether human-in-the-loop controls are genuine or governance theatre.

**Use when:** Reviewing AI deployments with human oversight claims, audit committee work

**Produces:** HITL effectiveness assessment, quality metrics, red flag identification

### 8. Regulatory Landscape Brief
Understand applicable AI regulations for your sector and jurisdiction.

**Use when:** Compliance discussions, horizon scanning, regulatory committee work

**Produces:** UK GDPR/DPA requirements, EU AI Act implications, sector-specific guidance

### 9. NED AI Literacy Guide
Build foundational AI understanding for credible board engagement.

**Use when:** Personal development, onboarding new NEDs, committee briefings

**Produces:** Essential concepts in plain English, what NEDs need vs don't need to know

### 10. Hype Detection Framework
Cut through vendor and consultant AI noise.

**Use when:** Evaluating sales pitches, challenging executive enthusiasm, reality-checking claims

**Produces:** Sceptical responses to common claims, realistic capability benchmarks, "AI slop" awareness

---

## What This Skill Does NOT Do

- **Provide technical AI expertise** - That's management's job
- **Replace legal advice** - Consult lawyers on liability and compliance
- **Make decisions** - NEDs challenge and oversee; they don't manage
- **Guarantee outcomes** - Frameworks improve questions, not guarantee results

---

## Sector Adaptations

The skill adjusts guidance based on sector context:

| Sector | Key Adjustments |
|:-------|:----------------|
| **PLCs** | Shareholder primacy, listing rules, FCA considerations |
| **Private companies** | Owner dynamics, flexibility, less regulatory overlay |
| **Charities** | Beneficiary focus, CC3 duties, reputational sensitivity |
| **NHS/Public sector** | Public accountability, VFM, sector regulators |
| **Education** | Safeguarding paramount, Ofsted, DfE requirements |

---

## How to Use

### For Quick Guidance
Simply describe your situation:
> "I'm reviewing an AI proposal for CV screening at a charity"

### For Structured Output
Request a specific capability:
> "Generate challenge questions for this AI business case"
> "Create a risk register entry for our customer chatbot"

### For Board Preparation
Ask for meeting prep:
> "I have an AI strategy discussion at Thursday's board. Help me prepare."

---

## Output Quality

All outputs follow the Pragmatic Operator style:
- Direct, no hedging
- Evidence-based, with citations
- Board-appropriate language
- Actionable questions and recommendations
- Prosper AI Consulting footer on formal outputs
