# Change Readiness Assessment Framework

## The 70:20:10 Investment Test

A diagnostic for evaluating AI programmes as change initiatives, not technology projects.

---

## Core Principle

> "AI adoption is a people-led change programme, not a technology project. The primary reason AI initiatives fail is treating them as technology implementations rather than organisational transformation."

---

## Investment Balance Test

| Category | Description | Healthy Range | Red Flag |
|:---------|:------------|:-------------:|:--------:|
| **People (70%)** | Training, change management, capability building, communications | 60-80% | <40% |
| **Process (20%)** | Workflow redesign, operating model, policy development | 15-25% | <10% |
| **Technology (10%)** | Licenses, infrastructure, integration | 10-20% | >50% |

### What Each Category Includes

**People Investment:**
- Training and capability building
- Change management resources
- Communications (sustained, two-way)
- Leadership time and sponsorship
- Adoption support and reinforcement

**Process Investment:**
- Workflow redesign and documentation
- Operating model changes
- Policy and governance development
- Role and job description updates
- Quality assurance and monitoring

**Technology Investment:**
- Software licenses and subscriptions
- Infrastructure and hosting
- Integration and technical implementation
- Security and compliance tooling
- Ongoing technical maintenance

---

## ROI Evidence by Approach

| Strategy | Typical ROI | Source |
|:---------|:-----------:|:-------|
| "Buy everyone a license" | Little to no identifiable ROI | Paul Bratcher NED Briefing |
| "Build a team to reinvent everything" | 20-40% within 1 year | Paul Bratcher NED Briefing |
| Outcome-focused with clear goals | 30-70% within 1 year | Paul Bratcher NED Briefing |

---

## Change Programme Components

For AI adoption to succeed, these elements must be present:

| Component | Board Oversight Question | Red Flag |
|:----------|:-------------------------|:---------|
| **Sponsorship** | Who owns this? Is there visible, sustained leadership commitment? | Named sponsor who isn't engaged |
| **Vision & Case for Change** | Can people articulate why this matters and what success looks like? | "Because competitors are doing it" |
| **Stakeholder Analysis** | Who is impacted? How? Have they been consulted? | No documented impact analysis |
| **Resistance Management** | Where will resistance come from? What's the plan? | "They'll adapt" |
| **Communication** | Is communication planned throughout, not just at launch? | Launch announcement only |
| **Training & Capability** | Are people equipped to work with AI effectively? | Token e-learning module |
| **Reinforcement** | How will new ways of working be reinforced and sustained? | Go-live is the finish line |
| **Measurement** | Are we measuring adoption, not just deployment? | Only tracking licenses deployed |

---

## Common Failure Patterns

| Pattern | Symptoms | Challenge Questions |
|:--------|:---------|:--------------------|
| **Technology-first thinking** | Business case focused on features, not outcomes | "What business outcome does this deliver? How will we measure it?" |
| **Underinvested change** | Token training, no communications plan | "What % of budget is people vs technology? Who is leading the change programme?" |
| **Leadership lip service** | Exec sponsor named but not engaged | "When did the sponsor last visibly champion this? What decisions have they made?" |
| **Ignoring resistance** | No stakeholder analysis | "Who opposes this and why? What have we done to address their concerns?" |
| **Big bang deployment** | Full rollout without pilots | "What did we learn from the pilot? What did we change as a result?" |
| **Declaring victory early** | Celebrating go-live, not adoption | "What's actual usage 6 months post-launch? What % of intended users are active?" |

---

## Adoption Metrics (Board Level)

| Metric | What It Measures | Target | Red Flag |
|:-------|:-----------------|:------:|:---------|
| **Awareness** | % of affected employees who understand the change | >90% | <70% |
| **Understanding** | % who can explain how their role changes | >80% | <60% |
| **Adoption** | % actively using AI tools as intended | >70% at 6 months | <40% |
| **Proficiency** | % achieving competency standards | >60% at 12 months | <30% |
| **Advocacy** | % who would recommend new ways of working | >50% | <30% |
| **Benefit Realisation** | % of projected benefits achieved | >80% at 18 months | <50% |

---

## Assessment Questions

When reviewing an AI business case or programme:

### Investment Balance
1. What is the split between People, Process, and Technology spend?
2. Does "implementation cost" include change management, or just technology?
3. What is the budget for sustained communications beyond launch?

### Change Programme Quality
4. Is there a dedicated change manager, or is this "additional duty" for someone?
5. What training is planned? How many hours? Is it role-specific?
6. What happens after go-live to embed new ways of working?

### Realistic Expectations
7. What is the timeline to benefit? (Beware <6 months for significant change)
8. How will we know people are actually using this, not just that it's deployed?
9. What is Plan B if adoption is slower than expected?

### Leadership Commitment
10. Has the executive sponsor cleared their diary for this?
11. What visible actions has leadership taken to signal priority?
12. What happens if this competes with other priorities?

---

## Key Insight

> "The 70:20:10 pattern is consistent across successful AI implementations. Organisations that invest proportionately in people see 3-7x better ROI than those who treat AI as a technology purchase."

---

## Reference

- Google/Public First AI Works 2025: 10:1 ROI on AI training
- McKinsey AI-First Playbook 2025: Operating model transformation
- Prosser/Kotter change management frameworks
- Paul Bratcher NED Briefing 2024: 70:20:10 success patterns
