# Delegation Authority Matrix

AI decision authority levels for board governance oversight.

---

## Six Levels of AI Decision Authority

| Level | Description | Human Role | AI Role | Board Oversight |
|:------|:------------|:-----------|:--------|:----------------|
| **1. Human Only** | No AI involvement | Full authority | None | Standard governance |
| **2. AI Informs** | AI provides data/analysis | Human decides | Information provision | Annual review |
| **3. AI Recommends** | AI proposes action | Human approves or modifies | Recommendation | Quarterly reporting |
| **4. AI Decides, Human Reviews** | AI operates, periodic oversight | Monitoring and exception handling | Primary decision-maker | Monthly KPIs |
| **5. AI Decides, Human Override** | AI autonomous, intervention capability | Exception-based intervention | Autonomous with override | Real-time dashboards |
| **6. Full Autonomy** | AI without intervention | None | Full authority | Continuous monitoring |

---

## Mapping Delegation to Impact

| Impact Level | Maximum Delegation | Rationale |
|:-------------|:-------------------|:----------|
| **I - Minimal** | Up to Level 5 | Low consequence, override available |
| **II - Moderate** | Up to Level 4 | Human review catches errors |
| **III - High** | Up to Level 3 | Human approval required for consequential decisions |
| **IV - Very High** | Level 2 maximum | AI informs only, human decides |

---

## Board Challenge Questions by Delegation Level

### Level 3+ (AI Recommends or Higher)

- "What percentage of AI recommendations are accepted without modification?"
- "If acceptance rate exceeds 95%, is human review adding value or providing false assurance?"
- "What training do reviewers receive to critically assess AI recommendations?"
- "How do we measure reviewer quality, not just throughput?"

### Level 4+ (AI Decides)

- "What triggers human review of an AI decision?"
- "How quickly can a human intervene when needed?"
- "What happens between the AI decision and the next human review?"
- "Are affected individuals informed that AI made the decision?"

### Level 5+ (AI Decides with Override)

- "How often is the override actually used?"
- "Is override capability tested regularly?"
- "What is our response time from detection to override?"
- "Who has override authority, and are they available 24/7?"

---

## Escalation Triggers

| Trigger | Action |
|:--------|:-------|
| Override rate exceeds 5% | Review AI model quality |
| Override rate drops below 0.1% | Review whether human oversight is genuine |
| Single high-impact error | Immediate review, potential suspension |
| Pattern of similar errors | Model retraining or delegation level reduction |
| Regulatory inquiry | Immediate board notification |

---

*Delegation Authority Matrix | NED AI Helper | Prosper AI Consulting, UK*
