# Fiduciary Duty Mapping for AI

Translating existing director, governor, and trustee duties to the AI context.

---

## Companies Act 2006 - Director Duties

| Duty (s.170-177) | Traditional Meaning | AI Translation |
|:------------------|:---------------------|:---------------|
| **s.171 Act within powers** | Operate within articles and constitution | Ensure AI use is within corporate objects; authorised by appropriate policy |
| **s.172 Promote success** | Act in good faith for benefit of members | AI should demonstrably benefit the company; weigh long-term consequences |
| **s.173 Independent judgement** | Exercise own judgement, not defer blindly | Do not defer to AI recommendations without critical assessment; understand AI limitations |
| **s.174 Reasonable care, skill, diligence** | General knowledge and competence expected | Maintain sufficient AI literacy to exercise oversight; seek expert advice where needed |
| **s.175 Avoid conflicts** | Avoid conflicts of interest | Scrutinise vendor relationships; ensure AI does not create hidden conflicts |
| **s.176 Not accept benefits** | Do not accept third-party benefits | Vendor hospitality and incentives in AI procurement; data-sharing arrangements |
| **s.177 Declare interests** | Disclose interests in transactions | Declare any personal AI investments, advisory roles, or vendor relationships |

---

## Charities Act 2011 - Trustee Duties

| Duty | Traditional Meaning | AI Translation |
|:-----|:---------------------|:---------------|
| **Compliance** | Act within charity objects | AI use must serve charitable purposes; not commercial interests |
| **Prudence** | Protect charity assets | Assess AI investment against beneficiary value; avoid speculative AI spending |
| **Care** | Act with reasonable care and skill | Understand AI risks to beneficiaries; seek advice where trustee knowledge is insufficient |
| **Duty to beneficiaries** | Act in beneficiaries' best interests | Ensure AI does not disadvantage the people the charity serves |

---

## Education (Governors)

| Duty | AI Translation |
|:-----|:---------------|
| **Safeguarding** | AI must not compromise child safety; rigorous assessment of any AI interacting with students |
| **Standards** | AI should demonstrably support educational outcomes, not replace professional judgement |
| **Financial oversight** | AI spending must represent value for money; evidence-based procurement |
| **Accountability** | Governors must understand AI used in the school well enough to answer to parents and regulators |

---

## Personal Liability Considerations

### When Could You Be Liable?

| Scenario | Risk | Mitigation |
|:---------|:-----|:-----------|
| AI causes harm and board never discussed it | High | Ensure AI is on the governance agenda |
| AI causes harm after board approved it | Lower if due diligence evidenced | Document challenge questions asked, assurances received |
| NED claims no AI knowledge | No defence if reasonable person would have inquired | Build sufficient AI literacy |
| AI vendor promised safety | Shared liability, not full defence | Independent assurance; do not rely solely on vendor claims |

### Competence Standard

The standard is the "reasonably diligent person" (s.174 Companies Act 2006):

- You do not need to be an AI expert
- You do need to ask intelligent questions
- You do need to understand the governance framework
- You do need to challenge when something does not add up
- You do need to seek expert advice when you lack knowledge

---

## Board Questions for Duty Compliance

1. "Has the board formally considered AI risk appetite?"
2. "Do we have sufficient AI expertise at board level, or should we appoint an advisor?"
3. "Are we satisfied that our AI oversight is proportionate to the impact?"
4. "Would our governance withstand regulatory scrutiny?"
5. "Can we demonstrate that we challenged this AI decision, not just approved it?"

---

*Fiduciary Duty Mapping | NED AI Helper | Prosper AI Consulting, UK*
