# AI Governance Structure Options

Board-level governance architecture for AI oversight.

---

## Four Options

### Option 1: Dedicated AI Committee

**Structure:** Standalone board committee for AI governance

| Aspect | Detail |
|:-------|:-------|
| **Best for** | Organisations with significant AI investment or high-impact use cases |
| **Composition** | 3-5 NEDs/Governors, CTO/CDO attendance, external AI advisor optional |
| **Frequency** | Quarterly minimum, monthly during implementation phases |
| **Reports to** | Full board |

**Pros:**
- Dedicated focus and expertise
- Clear accountability
- Depth of scrutiny

**Cons:**
- Resource-intensive
- Risk of becoming isolated from operational reality
- May duplicate Risk or Audit committee work

### Option 2: Risk Committee Expansion

**Structure:** Expand existing Risk Committee remit to include AI

| Aspect | Detail |
|:-------|:-------|
| **Best for** | Organisations with mature risk frameworks and moderate AI use |
| **Composition** | Existing Risk Committee plus AI-specific standing item |
| **Frequency** | As per existing schedule |
| **Reports to** | Full board via existing reporting line |

**Pros:**
- Integrates AI into existing risk management
- No additional committee overhead
- Risk expertise already present

**Cons:**
- AI may get crowded out by other risk agenda items
- Risk Committee may lack AI-specific knowledge
- Reactive rather than strategic oversight

### Option 3: Audit Committee Scope

**Structure:** Audit Committee takes on AI assurance and compliance

| Aspect | Detail |
|:-------|:-------|
| **Best for** | Regulated sectors where AI compliance is primary concern |
| **Composition** | Existing Audit Committee with AI audit focus |
| **Frequency** | As per existing schedule |
| **Reports to** | Full board via existing reporting line |

**Pros:**
- Natural fit for compliance and assurance
- Existing audit methodology applies
- Independent assurance mandate

**Cons:**
- Audit lens may miss strategic opportunities
- Audit capacity already stretched
- Not suited for forward-looking AI strategy

### Option 4: Full Board Agenda Item

**Structure:** AI as standing board agenda item (no separate committee)

| Aspect | Detail |
|:-------|:-------|
| **Best for** | Small organisations, early AI adoption, limited AI use cases |
| **Composition** | Full board |
| **Frequency** | Every board meeting (15-30 min slot) |
| **Reports to** | N/A (is the board) |

**Pros:**
- All board members engaged
- No additional governance structure
- Simple and proportionate

**Cons:**
- Limited time for depth
- Competing with other agenda items
- No specialist focus

---

## Recommendation Framework

| Factor | Dedicated Committee | Risk Expansion | Audit Scope | Board Agenda |
|:-------|:---:|:---:|:---:|:---:|
| **AI investment >500k/year** | Recommended | Acceptable | Not ideal | Insufficient |
| **Level III/IV use cases** | Recommended | Acceptable | Recommended | Insufficient |
| **Regulatory requirement** | Recommended | Acceptable | Recommended | Case-by-case |
| **Early/small scale** | Overkill | Acceptable | Acceptable | Recommended |
| **Charity/small org** | Overkill | Acceptable | Acceptable | Recommended |

---

## Implementation Checklist

Regardless of structure chosen:

- [ ] Terms of reference defined
- [ ] AI risk appetite statement agreed
- [ ] Reporting cadence confirmed
- [ ] Escalation triggers documented
- [ ] Annual effectiveness review scheduled
- [ ] Training plan for committee members

---

*AI Governance Structure Options | NED AI Helper | Prosper AI Consulting, UK*
