# Hype Detection Framework

Cutting through vendor and consultant AI noise for board members.

---

## Common Hype Patterns

### Pattern 1: The Urgency Play

**Claim:** "You need to act now or competitors will leave you behind."

**Sceptical response:**
- "Which specific competitors, and what exactly have they deployed?"
- "What is the evidence of competitive disadvantage from waiting 6 months?"
- "Is this urgency based on our market position or your sales quarter?"

### Pattern 2: The Transformation Promise

**Claim:** "AI will transform your organisation."

**Sceptical response:**
- "Transform how, specifically? Which processes, which outcomes?"
- "What is your evidence from similar organisations?"
- "What does 'transform' mean in measurable terms?"

### Pattern 3: The ROI Fantasy

**Claim:** "This will deliver 10x ROI within 12 months."

**Sceptical response:**
- "Show me the calculation, including all costs (implementation, training, change management, ongoing)"
- "What is your success rate with similar deployments?"
- "What is your definition of ROI, and does it include opportunity cost?"

### Pattern 4: The Everyone-Is-Doing-It

**Claim:** "80% of organisations are already using AI."

**Sceptical response:**
- "Using AI for what? Email summarisation or strategic decisions?"
- "What percentage are getting measurable value?"
- "How many of those are in our sector, at our scale?"

### Pattern 5: The Technology-First Pitch

**Claim:** "Our AI platform is the most advanced in the market."

**Sceptical response:**
- "We are not buying technology, we are buying outcomes. What outcome does this deliver?"
- "How does technical advancement translate to business value for us?"
- "What is the people and process investment required alongside this platform?"

---

## Red Flags in AI Proposals

| Red Flag | What It Suggests |
|:---------|:-----------------|
| No mention of change management | Technology-only thinking; likely to fail |
| ROI calculations excluding people costs | Understated true investment |
| Vendor case studies from different sectors | Limited relevant evidence |
| "AI will do X" without "humans will do Y" | Missing the human element |
| No mention of failure modes | Insufficient risk consideration |
| Promise of "seamless integration" | Underestimating implementation complexity |
| Pilot success claimed without control group | Weak evidence base |

---

## The 70:20:10 Hype Test

Apply the investment test to any AI proposal:

| Investment Area | Healthy Range | Red Flag |
|:----------------|:-------------|:---------|
| **People** (training, change, capability) | 60-80% | <40% |
| **Process** (workflow redesign, operating model) | 15-25% | <10% |
| **Technology** (licences, infrastructure) | 10-20% | >50% |

If the proposal allocates more than 50% to technology, challenge it. Evidence shows that technology-heavy, people-light approaches deliver poor outcomes.

---

## AI Slop Progression

Awareness of declining quality in AI-generated content:

| Stage | Description | Board Concern |
|:------|:------------|:-------------|
| **Novel** | AI outputs are fresh and useful | Low concern |
| **Familiar** | AI patterns become recognisable | Audience fatigue |
| **Saturated** | AI-generated content dominates | Loss of distinctiveness |
| **Degraded** | AI trained on AI output, quality declines | Quality and trust erosion |

**Board question:** "How do we maintain quality and distinctiveness as AI content becomes ubiquitous?"

---

## Credible AI Engagement

Instead of hype detection alone, these signals suggest a credible AI approach:

- Clear outcome definition before technology selection
- Honest acknowledgement of what AI cannot do
- Phased approach with measurable checkpoints
- Majority investment in people and process
- Evidence from comparable organisations
- Realistic timelines (months, not weeks)
- Named accountable individuals

---

*Hype Detection Framework | NED AI Helper | Prosper AI Consulting, UK*
