# Impact Classification Framework

Canada AIA (Algorithmic Impact Assessment) four-tier model adapted for UK board governance.

---

## Impact Levels

| Level | Impact | Characteristics | Board Oversight |
|:------|:-------|:----------------|:----------------|
| **I - Minimal** | Little to none | Reversible, brief, internal only | Standard governance |
| **II - Moderate** | Limited, reversible | Short-term effects, low stakes | Annual review |
| **III - High** | Significant, hard to reverse | Ongoing effects, affects rights | Quarterly reporting |
| **IV - Very High** | Severe, potentially irreversible | Perpetual, fundamental rights | Continuous monitoring |

---

## Classification Criteria

### Level I - Minimal Impact

**Characteristics:**
- Internal efficiency tools only
- No decisions affecting individuals
- Fully reversible outputs
- No personal data processing

**Examples:** Document summarisation, meeting scheduling, internal search, code generation

**Governance:** Standard IT procurement, no specific AI oversight required

### Level II - Moderate Impact

**Characteristics:**
- Limited external impact
- Readily reversible decisions
- Low-sensitivity personal data
- Human can easily override

**Examples:** Marketing content drafts, initial customer query routing, data analysis, report generation

**Governance:** Line management oversight, periodic review, published summary of use

### Level III - High Impact

**Characteristics:**
- Significant impact on individuals
- Difficult to reverse once enacted
- Sensitive personal data involved
- Affects rights, interests, or access

**Examples:** HR screening, credit pre-assessment, insurance risk scoring, educational assessment support

**Governance:** Dedicated oversight, specific HITL requirements, external review recommended, full disclosure

### Level IV - Very High Impact

**Characteristics:**
- Severe impact on individuals
- Potentially irreversible consequences
- Fundamental rights engaged
- Vulnerable populations affected

**Examples:** Safeguarding risk assessment, clinical decision support, benefits eligibility, judicial support

**Governance:** Human final decision required, independent audit, real-time explainability, ongoing accreditation

---

## Classification Questions

Use these to determine impact level:

1. **Who is affected?** Internal staff only (I-II) vs external individuals (II-IV) vs vulnerable groups (III-IV)
2. **What decisions are influenced?** Efficiency (I) vs operational (II) vs consequential (III-IV)
3. **Is the outcome reversible?** Easily (I-II) vs with difficulty (III) vs potentially not (IV)
4. **What data is involved?** None/aggregate (I) vs non-sensitive personal (II) vs sensitive (III-IV)
5. **What rights are engaged?** None (I) vs limited (II) vs significant (III) vs fundamental (IV)

---

## Board Questions by Level

### For Level III and IV Use Cases

- "What happens when this system gets it wrong?"
- "How do affected individuals appeal or challenge the decision?"
- "What is our liability if harm occurs?"
- "Are we satisfied that human oversight is genuine, not performative?"
- "Has this been independently reviewed?"

---

*Impact Classification Framework | NED AI Helper | Prosper AI Consulting, UK*
