# AI Regulatory Landscape

UK and EU regulatory requirements relevant to board AI oversight.

---

## UK Regulatory Framework

### UK GDPR and Data Protection Act 2018

| Requirement | AI Relevance |
|:------------|:-------------|
| **Lawful basis** | AI processing needs a lawful basis; legitimate interest requires balancing test |
| **Purpose limitation** | Training data and AI outputs must align with stated purposes |
| **Data minimisation** | Collect only what AI needs; avoid over-collection for "future use" |
| **Accuracy** | AI outputs affecting individuals must be accurate; right to correction applies |
| **Automated decision-making (Art 22)** | Individuals have right not to be subject to solely automated decisions with legal/significant effects |
| **DPIA requirement** | Data Protection Impact Assessment required for high-risk AI processing |
| **Transparency** | Individuals must be informed when AI is used in decisions affecting them |

### ICO AI Guidance

The Information Commissioner's Office has published guidance on:
- AI and data protection
- Explaining AI decisions
- AI auditing framework

**Board implication:** Ensure the organisation's AI use has been reviewed against ICO guidance.

---

## EU AI Act (Relevant to UK Organisations)

The EU AI Act applies to UK organisations that:
- Provide AI systems in the EU market
- Use AI whose output is used in the EU
- Have EU-based customers or employees

### Risk Categories

| Category | Examples | Requirements |
|:---------|:---------|:-------------|
| **Unacceptable** | Social scoring, real-time biometric surveillance | Prohibited |
| **High-risk** | HR recruitment, credit scoring, educational assessment | Conformity assessment, human oversight, transparency |
| **Limited risk** | Chatbots, deepfakes | Transparency obligations (inform users) |
| **Minimal risk** | Spam filters, AI in games | No specific requirements |

---

## Sector-Specific Regulation

### Financial Services (FCA/PRA)

| Requirement | Detail |
|:------------|:-------|
| **Model risk management** | SS1/23 covers AI/ML model governance |
| **Consumer Duty** | AI must support good customer outcomes |
| **Operational resilience** | AI systems must meet resilience standards |
| **Explainability** | FCA expects firms to explain AI-driven decisions |

### Healthcare (CQC)

| Requirement | Detail |
|:------------|:-------|
| **Clinical safety** | DCB0129/DCB0160 standards apply to clinical AI |
| **Medical devices** | AI clinical decision support may be regulated as medical device (MHRA) |
| **Patient consent** | Informed consent for AI in clinical pathways |

### Education (Ofsted/DfE)

| Requirement | Detail |
|:------------|:-------|
| **Safeguarding** | AI must not compromise child protection |
| **Data protection** | Children's data has enhanced protection |
| **Educational standards** | AI should support, not replace, professional judgement |

---

## Horizon Scanning

| Development | Timeline | Board Action |
|:------------|:---------|:-------------|
| UK AI Safety Institute outputs | Ongoing | Monitor guidance publications |
| EU AI Act full enforcement | August 2027 | Assess applicability to operations |
| ICO updated AI guidance | Ongoing | Review compliance annually |
| Sector-specific AI codes | 2025-2027 | Engage with industry consultations |

---

## Board Questions

1. "Have we mapped our AI use cases against applicable regulations?"
2. "Do we have a regulatory change process for AI-specific developments?"
3. "Has our DPO reviewed all AI processing activities?"
4. "If we operate in the EU, have we assessed EU AI Act applicability?"
5. "Are our sector-specific compliance teams aware of AI-specific requirements?"

---

*AI Regulatory Landscape | NED AI Helper | Prosper AI Consulting, UK*
