# Prosper AI Consulting - Tone Guidance

**Purpose:** Define the communication style for all Prosper AI Consulting outputs.

---

## Pragmatic Operator Style

All outputs follow Prosper AI Consulting's **Pragmatic Operator** style:

### Core Principles

1. **Direct and Actionable**
   - State conclusions first, then evidence
   - Use imperative verbs (Do, Implement, Stop)
   - Every recommendation should be implementable

2. **Evidence-Based**
   - Support claims with specific evidence
   - Acknowledge uncertainty via confidence levels
   - Distinguish fact from inference

3. **Trade-Off Aware**
   - Acknowledge effort alongside impact
   - Present alternatives where relevant
   - Be honest about limitations

4. **Specific Not Generic**
   - Use concrete examples from context
   - Avoid vague generalisations
   - Include numbers where possible

5. **Professional, Not Corporate**
   - Write clearly and directly
   - Avoid jargon and buzzwords
   - Plain English over impressive-sounding phrases

6. **Human-Centred**
   - Centre people even in technology discussions
   - "Our clients and people" not just "the business"
   - Acknowledge impact on individuals and teams
   - Technology serves people, not the reverse

7. **Grounded Confidence**
   - Confident but not grandiose
   - "Will help us achieve" not "will transform"
   - "Improve outcomes" not "revolutionise"
   - Promise what can be delivered

---

## Voice and Collaboration

### When to Use "We"

Use collaborative "we" voice to create shared ownership:

| Context | Voice | Example |
|:--------|:------|:--------|
| Client deliverables | "We" (inclusive) | "We will focus on building..." |
| Joint recommendations | "We" (collaborative) | "Our goal is to..." |
| Prosper-only analysis | "We" (Prosper) or impersonal | "The assessment shows..." |
| Objective findings | Impersonal | "The data indicates..." |

**Pattern:** Use "we" when building commitment and ownership. Use impersonal when stating objective facts.

### Candid Gap Acknowledgment

Build trust by honestly stating current limitations:

**Good:**
- "We do not currently have all the capabilities needed to..."
- "Without the right support, we are at risk of..."
- "Our teams lack experience in..."

**Then follow with solutions:**
- "To address this, we will..."
- "This is why we recommend..."

**Avoid:**
- Glossing over gaps
- Overstating current capabilities
- Defensiveness about limitations

### Risk-Mitigation-Contingency Pattern

When discussing risks, use this three-part structure:

1. **State the Risk Honestly**
   - Be specific about what could go wrong
   - Acknowledge real consequences
   - Do not minimise

2. **Present Mitigation**
   - Concrete steps already in place or planned
   - Who is responsible
   - How it reduces the risk

3. **Include Contingency**
   - What happens if the risk materialises despite mitigation
   - Recovery options
   - Escalation path

**Example:**
> **Risk:** Resource strain may cause core contributors to be pulled away by operational pressures.
>
> **Mitigation:** Regular check-ins every two weeks will surface blockers early. Committee members are accountable for ensuring appropriate capacity within their departments.
>
> **Contingency:** If pressure builds, we can extend the timeline, bring in additional support, or allocate responsibility to others within the wider business.

---

## Language Requirements

### UK English Spelling

| Correct (UK) | Incorrect (US) |
|:-------------|:---------------|
| organisation | organisation |
| behaviour | behavior |
| colour | color |
| prioritise | prioritize |
| analyse | analyze |
| optimise | optimize |
| recognise | recognize |
| summarise | summarize |
| centre | center |
| programme | program |
| favour | favor |
| licence (noun) | license |
| judgement | judgment |
| focussed | focused |

### Forbidden Hedge Words

**Never use:**
- potentially
- possibly
- might consider
- could perhaps
- arguably
- it seems
- appears to
- somewhat
- relatively

**Replace with:**
- Direct statements
- Confidence levels (High/Medium/Low)
- Conditional statements ("If X, then Y")

### Forbidden Corporate Speak

**Never use:**
- synergy
- leverage (as verb)
- paradigm shift
- touch base
- low-hanging fruit
- move the needle
- circle back
- best-in-class
- thought leadership
- deep dive (as noun)
- cutting-edge
- revolutionary
- game-changing

**Replace with:**
- Plain English equivalents
- Specific descriptions

---

### Forbidden AI/Marketing Patterns

**Never use the dramatic contrast pattern:**
- "This is not X. This is Y."
- "This is not just X. It is Y."
- "We do not X. We Y."

This pattern reads like American movie poster hyperbole. It implies the reader needs correcting and sounds like marketing copy.

**Bad examples:**
- "This is not a technology project. This is a business transformation."
- "This is not just pizza. It is an earth-shattering dining experience."
- "This is not rebuilding IQ. This is figuring out what IQ actually does."

**Replace with direct statements:**
- "We figure out what IQ actually does, document it, and give you a plan."
- "The engagement delivers X, Y, and Z."
- Just say what it is. Skip the dramatic setup.

---


## Punctuation

### No Em Dashes

**Incorrect:** The assessment — which covers seven dimensions — provides clarity.

**Correct:** The assessment (which covers seven dimensions) provides clarity.

**Also correct:** The assessment covers seven dimensions. It provides clarity.

Use hyphens, colons, or sentence breaks instead.

### Number Ranges

Use "to" not em dashes:
- "5 to 10 days" not "5—10 days"
- "2025 to 2026" not "2025–2026"

### Date Format

Use UK day-month-year:
- "3 December 2025" (preferred)
- "03/12/2025" (acceptable in tables)

---

## ODTA Terminology

### General Terms

| Use This | Not This |
|:---------|:---------|
| Technology adoption | Digital transformation |
| Quick wins | Low-hanging fruit |
| Effective practice | Best practice |
| Organisation | Company, Firm (unless specific) |
| Experiment | Pilot, POC (unless client prefers) |
| Findings | Learnings |
| Issue | Problem |
| Opportunity | Low-hanging fruit |
| Review | Deep dive |
| Analyse | Unpack |

### ODTA Maturity Stage Names

| Use This | Not This |
|:---------|:---------|
| Tech-Support | Basic, Foundation, Initial |
| Tech-Augmented | Emerging, Developing |
| Tech-Enabled | Advanced, Integrated |
| Tech-Driven | Mature, Optimised |
| Tech-Centric | Leading, Innovative |

---

## Document Formatting

### Structure

1. **Executive Summary First**
   - Key findings (3-5 bullets)
   - Overall assessment
   - Top priorities

2. **Tables Over Prose**
   - Use tables for comparisons and structured data
   - Use lists for sequential information
   - Reserve prose for narratives and context

3. **Clear Hierarchy**
   - H1 for document title (one per document)
   - H2 for major sections
   - H3 for subsections
   - H4 for detail (use sparingly)

### Lists

Use bullets for unordered items:
- Keep items parallel in structure
- Start with verbs for actions
- Avoid nested lists beyond two levels

Use numbers for sequences:
1. Steps that must follow order
2. Priorities with ranking
3. Timelines

### Tables

- Keep tables simple (3-5 columns max)
- Use clear header names
- Align text left, numbers right

---

## Audience Considerations

### Primary Audience: Senior Leaders

**Characteristics:**
- Time-poor
- Decision-focused
- Want clarity not complexity
- Appreciate directness

**Adapt by:**
- Leading with key findings
- Providing clear priority actions
- Using business language, not jargon
- Including "so what" for every finding

### Secondary Audience: Implementation Teams

**Characteristics:**
- More detail-oriented
- Interested in evidence
- Will execute recommendations
- Need practical guidance

**Adapt by:**
- Including full evidence
- Providing detailed analysis
- Including phased approaches
- Offering actionable next steps

---

## Footer Standards

### Client Documents

```markdown
---

*[Document Type] | [Client Name] | [Date]*
*Prosper AI Consulting, UK*
```

### Internal Documents

```markdown
---

*[Document Type] | Prosper AI Consulting*
```

---

## Quality Checklist

Before finalising any output, verify:

- [ ] UK English spelling throughout
- [ ] No hedge words or corporate speak
- [ ] No em dashes (use "to" for ranges)
- [ ] Correct terminology used
- [ ] Active voice preferred
- [ ] Evidence supports claims
- [ ] Tables formatted consistently
- [ ] Footer attribution present
- [ ] One H1 title only
- [ ] Clear heading hierarchy
- [ ] Recommendations are actionable
- [ ] Human-centred language (people, not just process)
- [ ] Grounded confidence (help, not transform)
- [ ] Gaps acknowledged honestly with solutions
- [ ] Risks include mitigation and contingency

---

## Client-Facing Explanation

When explaining the tone to clients:

> These documents are written in the **Pragmatic Operator** tone:
>
> - **Direct** - No hedging or corporate waffle. Findings are stated clearly.
> - **Evidence-based** - Every assertion is backed by specific evidence.
> - **Actionable** - Recommendations are specific and implementable.
> - **Honest** - Gaps and limitations are stated transparently.
>
> If something reads bluntly, that is intentional. The goal is clarity, not comfort.

---

*Prosper AI Consulting | Tone Guidance*
