# AI Glossary for Board Members

Board-appropriate definitions of essential AI terminology.

---

## Essential Terms

| Term | Plain English Definition | Why It Matters |
|:-----|:------------------------|:---------------|
| **Artificial Intelligence (AI)** | Software that can perform tasks typically requiring human judgement | Umbrella term; specificity matters for governance |
| **Machine Learning (ML)** | AI that learns patterns from data rather than following explicit rules | Most current AI uses ML; data quality drives output quality |
| **Large Language Model (LLM)** | AI trained on vast amounts of text to generate human-like responses | ChatGPT, Claude, Gemini are LLMs; foundation of most current AI tools |
| **Generative AI** | AI that creates new content (text, images, code) | The current wave of AI adoption; both opportunity and risk |
| **Algorithm** | A set of rules or instructions a computer follows | Not all algorithms are AI; AI algorithms learn and adapt |
| **Training Data** | The information AI learned from | Garbage in, garbage out; biased data creates biased AI |
| **Fine-tuning** | Customising a general AI model for a specific purpose | Relevant when vendors claim "bespoke" solutions |
| **Prompt** | The instruction given to an AI to get a response | Staff skill in writing prompts affects AI output quality |
| **Hallucination** | AI generating plausible but false information with confidence | Critical risk; AI can be confidently wrong |
| **Bias** | Systematic errors in AI output reflecting patterns in training data | Legal, ethical, reputational risk; particularly in HR and customer-facing use |
| **Explainability** | The ability to understand and articulate why AI produced a specific output | Regulatory requirement for high-impact decisions; essential for accountability |
| **RAG (Retrieval-Augmented Generation)** | AI that looks up information from a knowledge base before answering | Reduces hallucination in enterprise settings; common in corporate AI |
| **Agent** | AI that can take actions autonomously, not just generate text | Emerging capability; raises delegation and oversight questions |
| **Token** | A unit of text (roughly a word or part of a word) that AI processes | Affects cost and capability limits; vendors may reference token limits |

---

## Governance-Specific Terms

| Term | Definition | Board Relevance |
|:-----|:-----------|:----------------|
| **HITL (Human-in-the-Loop)** | A human reviews or approves AI outputs before action | Key governance control; must be genuine, not performative |
| **AI Impact Assessment** | Structured evaluation of potential effects of an AI system | Required for high-risk AI under emerging regulation |
| **Algorithmic audit** | Independent review of AI system fairness and effectiveness | Emerging assurance practice; boards should request for high-impact AI |
| **Model risk** | The risk that an AI model produces inaccurate or harmful outputs | Part of operational risk; FCA SS1/23 covers this for financial services |
| **Shadow AI** | Unauthorised AI use by employees (personal ChatGPT accounts for work) | Common and often invisible; policy and detection needed |
| **Data governance** | Rules and processes for managing organisational data | Foundation for responsible AI; weak data governance undermines AI |

---

## Terms You May Hear (But Do Not Need to Understand Deeply)

| Term | What to Know | What to Ask |
|:-----|:-------------|:-----------|
| **Transformer architecture** | The technology behind modern LLMs | "What matters for us is the output quality, not the architecture" |
| **Neural network** | Computing system inspired by the brain | "How does this translate to business value?" |
| **GPU/TPU** | Specialised computing hardware for AI | "What are the infrastructure costs?" |
| **Embedding** | How AI represents concepts numerically | "Can the system explain its reasoning?" |
| **Reinforcement learning** | AI that learns through trial and error | "How do we ensure it learns the right behaviours?" |

---

## Common Acronyms

| Acronym | Full Term |
|:--------|:----------|
| **AI** | Artificial Intelligence |
| **ML** | Machine Learning |
| **LLM** | Large Language Model |
| **NLP** | Natural Language Processing |
| **RAG** | Retrieval-Augmented Generation |
| **HITL** | Human-in-the-Loop |
| **DPIA** | Data Protection Impact Assessment |
| **AIA** | Algorithmic Impact Assessment |

---

*AI Glossary for Board Members | Prosper AI Consulting, UK*
