# AI Proposal Challenge Questions

## Initial Review Framework for Board/Committee Members

Use these questions to challenge AI proposals before approval. Tailor to your sector and specific proposal.

---

## Strategic Fit

1. What specific business problem does this solve, and how was that problem prioritised?
2. How does this align with our stated strategic objectives?
3. What alternatives were considered, including non-AI solutions?
4. Why now? What has changed to make this the right time?
5. What is the cost of doing nothing for 12 months?

---

## Business Case Validity

6. What are the key assumptions underlying the ROI projection?
7. How does this compare to industry benchmarks for similar implementations?
8. What is the realistic timeline to value, accounting for the 70:20:10 pattern?
9. What costs might be missing from this business case?
   - Change management and communications
   - Ongoing maintenance and monitoring
   - Retraining and capability building
   - Integration with existing systems
10. What is the investment split between People, Process, and Technology?
    - **Red flag:** Technology >50% or People <40%

---

## Risk Assessment

11. What is the impact classification for this use case (Level I-IV)?
12. What happens if this goes wrong? What is our maximum downside exposure?
13. How will we know if the AI is making biased or incorrect decisions?
14. What human oversight is built into the design?
15. What are the three most likely ways this could fail?
16. What is the exit strategy if this does not work?

---

## Implementation Readiness

17. Do we have the data required, and is it of sufficient quality?
18. Do we have the skills to implement and operate this?
19. What is the change management approach for affected employees?
20. What did we learn from the pilot? What did we change as a result?
21. What percentage of intended users will be actively using this at 6 months?

---

## Governance & Compliance

22. Who owns this if it goes wrong?
23. What regulatory requirements apply, and how are we meeting them?
24. How will this be monitored and reported to the board?
25. What is the review and escalation mechanism?
26. Have we conducted an Algorithmic Impact Assessment?

---

## Human-in-the-Loop Specific

27. What information does the human reviewer actually see? Can I see a sample?
28. How long does a typical review take? Is that sufficient for a meaningful decision?
29. What training do reviewers receive? How is competence assessed?
30. What is our expected override rate, and what would concern us?
31. Do reviewers have genuine authority to override, or are they pressured to accept?

---

## Vendor & Procurement (if applicable)

32. How do we avoid vendor lock-in? What is our exit provision?
33. What independent verification of vendor claims do we have?
34. Where does our data go? Who has access?
35. What happens if the vendor fails or is acquired?

---

## Questions to Ask Yourself

Before the meeting, consider:

- What don't I understand that I should?
- What would I need to see to be confident in approval?
- What question would I ask if I weren't worried about looking uninformed?
- What is management NOT telling me?

---

**Prosper AI Consulting**
Pragmatic change, AI and implementation support.
Fractional Strategy, CAIO, CTO and CIO services.

Paul Bratcher | Partner
paul.bratcher@prosperconsulting.ai
+44 7894 701014
linkedin.com/in/paul-bratcher/

prosperconsulting.ai

---
