---
name: accessibility-compliance
description: Ensure cultural programs and facilities meet ADA requirements and universal design principles including accommodations, assistive technologies, and inclusive practices
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Accessibility Compliance

Ensure cultural programs and facilities meet ADA requirements and universal design principles including accommodations, assistive technologies, and inclusive practices.

## Overview

This skill enables comprehensive accessibility planning for cultural organizations. It encompasses ADA compliance, universal design implementation, assistive technology integration, and inclusive program development to ensure equitable access for all visitors.

## Capabilities

### ADA Compliance
- Assess facility compliance with ADA
- Evaluate program accessibility
- Review digital accessibility standards
- Identify and address barriers
- Document compliance efforts

### Universal Design
- Apply universal design principles
- Create inclusive exhibition experiences
- Design accessible communications
- Develop multi-sensory programming
- Consider diverse visitor needs

### Assistive Technologies
- Evaluate assistive technology options
- Implement audio description
- Provide assistive listening systems
- Offer accessible digital content
- Train staff on technology use

### Inclusive Practices
- Develop staff training programs
- Create accessible visitor services
- Design inclusive programs
- Engage disability community
- Build accessibility culture

## Usage Guidelines

### Assessment Process
1. Conduct accessibility audits
2. Identify barriers to access
3. Prioritize improvements
4. Develop remediation plans
5. Implement changes systematically
6. Monitor and evaluate effectiveness

### Design Standards
- Follow WCAG for digital content
- Apply ADA Standards for physical spaces
- Consider cognitive accessibility
- Plan for sensory sensitivities
- Ensure wayfinding accessibility

### Communication Guidelines
- Use plain language principles
- Provide multiple format options
- Offer appropriate accommodations
- Train frontline staff
- Respond to feedback constructively

## Integration Points

### Related Processes
- Visitor Experience Design Process
- Community Engagement Process
- Education Program Development Process

### Collaborating Skills
- exhibition-design
- interpretive-writing
- digital-engagement-strategy

## References

- ADA National Network resources
- Smithsonian Accessibility Program
- WCAG 2.1 Guidelines
- Universal design principles
