---
name: accreditation-tracer-simulation
description: Simulate Joint Commission tracer methodology to assess compliance with accreditation standards across patient care processes and support systems
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Accreditation Tracer Simulation

Simulate Joint Commission tracer methodology to assess compliance with accreditation standards across patient care processes and support systems.

## Overview

This skill enables simulation of accreditation tracer activities. It encompasses tracer methodology application, compliance assessment, gap identification, and survey preparation to ensure readiness for accreditation surveys.

## Capabilities

### Individual Tracers
- Follow patient journey
- Assess care delivery
- Review documentation
- Interview staff
- Observe processes

### System Tracers
- Infection control
- Medication management
- Data management
- Life safety
- Emergency management

### Assessment Methods
- Document review
- Staff interviews
- Process observation
- Environment of care
- Patient interaction

### Gap Identification
- Standard compliance gaps
- Documentation deficiencies
- Process breakdowns
- Knowledge gaps
- Environmental issues

## Usage Guidelines

### Tracer Process
1. Select tracer type/focus
2. Prepare tracer materials
3. Conduct tracer activities
4. Document findings
5. Assess compliance
6. Identify gaps
7. Plan remediation

### Individual Tracer Steps
1. Select patient case
2. Review medical record
3. Follow care processes
4. Interview care team
5. Observe practices
6. Assess compliance
7. Document findings

### System Tracer Focus Areas
- High-risk processes
- Cross-departmental systems
- National Patient Safety Goals
- Sentinel event prevention
- Regulatory requirements

## Integration Points

### Related Processes
- Joint Commission Survey Readiness
- HRO Implementation
- Quality Reporting Program Compliance

### Collaborating Skills
- regulatory-compliance-assessment
- quality-metrics-measurement
- patient-safety-event-analysis

## References

- Joint Commission standards
- Tracer methodology guides
- Survey process information
- Accreditation preparation resources
