# Advanced Data Structures Library

A skill for providing advanced data structure implementations.

## Overview

This skill provides implementations and guidance for sophisticated data structures used in competitive programming and advanced algorithmic problems.

## Key Features

- Balanced BST implementations
- Tree decomposition techniques
- Persistent data structures
- Wavelet tree operations
- Link-cut tree support

## Data Structure Categories

### Balanced BSTs
- Treap
- Splay Tree
- AVL/Red-Black Tree

### Tree Decomposition
- Heavy-Light Decomposition
- Centroid Decomposition

### Advanced
- Link-Cut Trees
- Wavelet Tree
- Persistent Structures

## Related Skills

- SK-ALGO-016: data-structure-selector
- SK-ALGO-017: segment-tree-builder
- SK-ALGO-005: code-template-manager
