---
name: aero-cfd
description: Vehicle aerodynamics simulation and optimization expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - vehicle-design
    - aerodynamics
    - cfd
    - simulation
---

# Aerodynamics CFD Skill

## Purpose
Provide vehicle aerodynamics simulation and optimization expertise for drag reduction, cooling airflow, and wind noise prediction.

## Capabilities
- Full vehicle CFD simulation (Star-CCM+, Fluent)
- Drag and lift coefficient analysis
- Underbody flow optimization
- Cooling airflow management
- Wind noise prediction
- Soiling and water management
- Rotating wheel modeling
- Active aerodynamics simulation

## Usage Guidelines
- Use appropriate mesh resolution for aerodynamic features
- Validate CFD against wind tunnel data
- Optimize underbody for drag reduction
- Ensure adequate cooling airflow to heat exchangers
- Predict wind noise sources for NVH improvement
- Document aerodynamic performance coefficients

## Dependencies
- Star-CCM+
- ANSYS Fluent
- PowerFLOW
- ANSA

## Process Integration
- VSE-001: Vehicle Architecture Definition
- TVL-001: Vehicle-Level Validation Testing
