---
name: amortized-analysis-assistant
description: Apply amortized analysis techniques including aggregate, accounting, and potential methods
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: algorithm-analysis
  phase: 6
---

# Amortized Analysis Assistant

## Purpose

Provides expert guidance on amortized analysis of data structures and algorithms using multiple analysis techniques.

## Capabilities

- Aggregate method calculations
- Accounting method with credit tracking
- Potential function design and verification
- Banker's method for persistent data structures
- Generate amortized bounds documentation
- Handle complex operation sequences

## Usage Guidelines

1. **Method Selection**: Choose appropriate amortized analysis method
2. **Potential Design**: Design potential function for potential method
3. **Credit Tracking**: Track credits for accounting method
4. **Bound Derivation**: Derive amortized cost bounds
5. **Documentation**: Generate clear analysis documentation

## Tools/Libraries

- Symbolic computation
- LaTeX documentation
- Proof assistants
