---
name: analogy-mapper
description: Skill for identifying and mapping analogies across domains
allowed-tools:
  - Read
  - Write
  - Bash
metadata:
  specialization: scientific-discovery
  domain: science
  category: Hypothesis Development
  skill-id: SK-SCIDISC-010
---

# Analogy Mapper Skill

## Purpose

Identify and map structural analogies across scientific domains to enable cross-domain insight transfer and creative hypothesis generation.

## Capabilities

- Identify structural similarities
- Map relationships across domains
- Transfer insights between fields
- Generate analogical hypotheses
- Evaluate analogy strength
- Document mappings

## Usage Guidelines

1. Define source domain
2. Identify target domain
3. Map structural elements
4. Identify correspondences
5. Generate insights
6. Evaluate validity

## Process Integration

Works within scientific discovery workflows for:
- Cross-domain discovery
- Creative hypothesis generation
- Knowledge transfer
- Pattern recognition

## Configuration

- Domain ontologies
- Mapping algorithms
- Similarity metrics
- Output formatting

## Output Artifacts

- Analogy mappings
- Structural correspondences
- Insight reports
- Validity assessments
