---
name: anaplan-planning
description: Anaplan connected planning for territory and quota management
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: sales
  domain: business
  priority: P1
  integration-points:
    - Anaplan API
---

# Anaplan Planning

## Overview

The Anaplan Planning skill provides integration with Anaplan's connected planning platform for territory modeling, quota allocation scenarios, headcount planning, and revenue planning models. This skill enables sophisticated, data-driven sales planning at scale.

## Capabilities

### Territory Modeling
- Design and optimize territories
- Balance workload and opportunity
- Model coverage scenarios
- Analyze territory performance

### Quota Allocation
- Distribute quotas across teams
- Model allocation scenarios
- Reconcile top-down and bottom-up
- Track allocation fairness

### Headcount Planning
- Plan sales capacity requirements
- Model hiring scenarios
- Project ramp impact
- Optimize team structure

### Revenue Planning
- Create revenue models and forecasts
- Scenario plan for different outcomes
- Track plan vs actual
- Adjust plans dynamically

## Usage

### Territory Design
```
Model territory configurations to optimize coverage and balance opportunity across the sales team.
```

### Quota Distribution
```
Allocate annual quotas across territories and reps based on opportunity and historical performance.
```

### Capacity Planning
```
Model headcount requirements to achieve revenue targets with appropriate ramp assumptions.
```

## Enhances Processes

- territory-design-assignment
- quota-setting-allocation
- revenue-forecasting-planning

## Dependencies

- Anaplan subscription
- Model configuration
- Data integration setup
