---
name: archival-finding-aid-interpretation
description: Navigate finding aids, catalog systems, and archival hierarchies to locate relevant collections and documents efficiently
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Archival Finding Aid Interpretation

Navigate finding aids, catalog systems, and archival hierarchies to locate relevant collections and documents efficiently.

## Overview

This skill enables effective use of archival resources. It encompasses finding aid interpretation, catalog navigation, and collection discovery to support efficient archival research across repositories.

## Capabilities

### Finding Aid Navigation
- Hierarchical structure understanding
- Series and subseries identification
- Container list interpretation
- Scope and content analysis
- Access conditions review

### Catalog Systems
- Online catalog searching
- Controlled vocabulary usage
- Cross-reference following
- Holdings identification
- Related materials discovery

### Archival Principles
- Provenance understanding
- Original order respect
- Arrangement levels
- Description standards
- Access frameworks

### Research Strategy
- Repository selection
- Collection prioritization
- Request preparation
- Time management
- Follow-up planning

## Usage Guidelines

### Research Process
1. Identify potential repositories
2. Search online catalogs
3. Review finding aids
4. Identify relevant materials
5. Plan repository visits
6. Submit requests
7. Document sources

### Finding Aid Components
- Collection overview
- Biographical/historical note
- Scope and content
- Arrangement description
- Container list
- Access restrictions

### Search Strategies
- Combine search terms
- Use controlled vocabularies
- Check related collections
- Follow cross-references
- Contact archivists

## Integration Points

### Related Processes
- Archival Research Methodology
- Primary Source Analysis
- Digital Archive Development

### Collaborating Skills
- primary-source-evaluation
- metadata-standards-implementation
- citation-scholarly-apparatus

## References

- DACS standards
- EAD encoding
- Archival theory
- Research methodology guides
