---
name: argument-mapping-reconstruction
description: Extract arguments from complex texts, identify premises, conclusions, and implicit assumptions, and create visual argument maps using Toulmin model or standard form
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Argument Mapping and Reconstruction Skill

Extract, analyze, and visualize arguments from complex philosophical texts with systematic mapping techniques.

## Overview

The Argument Mapping and Reconstruction skill enables systematic extraction of arguments from complex texts, identification of premises, conclusions, and implicit assumptions, and creation of visual argument maps using the Toulmin model, standard form, or other diagrammatic representations.

## Capabilities

### Argument Extraction
- Identify arguments within complex texts
- Distinguish arguments from explanations and descriptions
- Locate main conclusions and sub-conclusions
- Extract supporting premises
- Identify implicit assumptions and enthymemes

### Standard Form Analysis
- Reconstruct arguments in standard logical form
- Number and organize premises clearly
- Identify intermediate conclusions
- Distinguish deductive from inductive arguments
- Assess argument structure

### Toulmin Model Application
- Identify claims, grounds, and warrants
- Recognize backing and qualifiers
- Analyze rebuttals and counterarguments
- Apply model to different argument types
- Create Toulmin diagrams

### Visual Mapping
- Create clear argument diagrams
- Show logical relationships between claims
- Indicate support and attack relations
- Map complex argument networks
- Use standard diagramming conventions

## Usage Guidelines

### When to Use
- Analyzing philosophical texts
- Evaluating argument quality
- Teaching critical thinking
- Preparing scholarly critiques
- Developing own arguments

### Best Practices
- Read texts carefully and completely
- Identify all stated and unstated premises
- Preserve original meaning during reconstruction
- Use consistent mapping conventions
- Check reconstructions for accuracy

### Integration Points
- Formal Logic Analysis skill
- Fallacy Detection and Analysis skill
- Scholarly Literature Synthesis skill
- Philosophical Writing and Argumentation skill

## References

- Argument Reconstruction and Analysis process
- Fallacy Identification and Classification process
- Peer Review and Scholarly Critique process
- Logic Analyst Agent
- Academic Philosophy Writer Agent
