# ARM Cortex-M Skill

Deep expertise in ARM Cortex-M architecture and peripherals.

## Purpose

Provides comprehensive ARM Cortex-M development support:
- CMSIS configuration and integration
- NVIC interrupt priority management
- MPU region setup and protection
- Fault handler analysis and debugging
- Low-level optimization techniques

## Key Features

- Full Cortex-M family support (M0 to M55)
- NVIC and interrupt configuration
- MPU memory protection
- SysTick and DWT timers
- Fault analysis and debugging
- Assembly optimization

## Integration

Used by processes requiring Cortex-M expertise:
- BSP development
- ISR design and implementation
- Memory architecture planning
- Real-time system design
- Bootloader implementation

## Dependencies

- ARM CMSIS headers
- Cortex-M technical reference manuals
- Device-specific header files
