---
name: assessment-item-development
description: Create valid, reliable assessment items across formats (multiple choice, constructed response, performance tasks) following psychometric best practices
allowed-tools: Read, Grep, Write, Edit, Glob
---

# Assessment Item Development

Create valid, reliable assessment items across formats including multiple choice, constructed response, and performance tasks following psychometric best practices.

## Overview

This skill enables the development of high-quality assessment items that accurately measure learning outcomes. It encompasses item writing across formats, alignment with objectives, and application of psychometric principles to create valid and reliable assessments.

## Capabilities

### Multiple Choice Items
- Write clear, unambiguous stems
- Develop plausible distractors
- Avoid item-writing flaws
- Address various cognitive levels
- Apply item analysis principles

### Constructed Response
- Design short-answer items
- Create essay prompts
- Develop case-based questions
- Write open-ended problems
- Create scoring guidelines

### Performance Tasks
- Design authentic tasks
- Develop task specifications
- Create rubrics and scoring guides
- Plan administration conditions
- Document task requirements

### Quality Assurance
- Review for bias and sensitivity
- Verify content alignment
- Apply item statistics
- Conduct item review
- Document item metadata

## Usage Guidelines

### Item Development Process
1. Review learning objectives
2. Select appropriate item format
3. Draft items following guidelines
4. Review and revise items
5. Pilot test when possible
6. Analyze and refine

### Multiple Choice Guidelines
- Single correct answer
- Parallel answer choices
- Avoid "all of the above"
- Place correct answer randomly
- Keep options similar length

### Constructed Response Guidelines
- Clear task requirements
- Specific scoring criteria
- Appropriate scope
- Sufficient context
- Model responses available

## Integration Points

### Related Processes
- Formative Assessment Design
- Summative Assessment Development
- Item Writing and Test Development

### Collaborating Skills
- learning-objectives-writing
- rubric-design-validation
- learning-analytics-interpretation

## References

- Item writing guidelines (Haladyna)
- ETS item development standards
- Psychometric principles
- Assessment best practices
