---
name: audience-analytics
description: Analyze visitor data, attendance patterns, and engagement metrics to inform programming decisions and measure organizational impact
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# Audience Analytics

Analyze visitor data, attendance patterns, and engagement metrics to inform programming decisions and measure organizational impact.

## Overview

This skill enables systematic analysis of audience data for cultural organizations. It encompasses visitor research, attendance analysis, engagement measurement, and impact assessment to inform strategic and programmatic decision-making.

## Capabilities

### Visitor Data Analysis
- Analyze ticketing and admission data
- Segment audiences by demographics
- Track membership and repeat visitation
- Evaluate geographic reach
- Assess visitor pathways and behaviors

### Attendance Patterns
- Identify seasonal and temporal trends
- Analyze program-specific attendance
- Compare historical performance
- Forecast future attendance
- Benchmark against peers

### Engagement Metrics
- Measure digital engagement
- Track social media performance
- Assess email and marketing effectiveness
- Evaluate program participation
- Monitor membership engagement

### Impact Assessment
- Develop impact indicators
- Measure educational outcomes
- Assess community benefit
- Calculate economic impact
- Report on mission achievement

## Usage Guidelines

### Data Collection
1. Establish data collection protocols
2. Ensure privacy compliance
3. Integrate multiple data sources
4. Maintain data quality standards
5. Document methodology

### Analysis Approaches
- Apply descriptive statistics
- Conduct trend analysis
- Perform segmentation studies
- Use predictive modeling
- Create visualization dashboards

### Reporting Standards
- Tailor reports to stakeholder needs
- Visualize data effectively
- Provide actionable insights
- Document limitations
- Track metrics over time

## Integration Points

### Related Processes
- Marketing Campaign Process
- Visitor Experience Design Process
- Cultural Impact Assessment Process

### Collaborating Skills
- donor-relationship-management
- digital-engagement-strategy

## References

- AAM Visitor Studies resources
- Visitor Studies Association standards
- Cultural analytics methodologies
- Museum metrics frameworks
