---
name: audit-workpaper-generator
description: Automated audit workpaper preparation skill with PBC list management
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: finance-accounting
  domain: business
  category: reporting-analytics
  priority: medium
---

# Audit Workpaper Generator

## Overview

The Audit Workpaper Generator skill provides automated audit workpaper preparation capabilities. It supports PBC (Prepared by Client) list management, workpaper documentation, and evidence organization for audit support.

## Capabilities

### PBC List Generation and Tracking
- Request list creation
- Due date assignment
- Status tracking
- Reminder automation
- Completion monitoring
- Version management

### Workpaper Template Population
- Standard template library
- Automatic data population
- Period roll-forward
- Prior year comparison
- Variance explanation
- Conclusion drafting

### Tickmark Documentation
- Standard tickmark library
- Legend maintenance
- Consistent application
- Audit trail creation
- Review tracking
- Sign-off workflow

### Cross-Reference Linking
- Workpaper navigation
- Source documentation
- Trial balance ties
- Lead schedule links
- Supporting detail access
- Reference integrity

### Support Schedule Creation
- Account analysis
- Transaction testing support
- Reconciliation formatting
- Calculation documentation
- Evidence attachment
- Exception tracking

### Document Organization
- Logical structure
- Naming conventions
- Version control
- Access management
- Archive procedures
- Retrieval capability

## Usage

### Audit Preparation
```
Input: Audit scope, prior year files, current period data
Process: Generate PBC list, prepare workpapers, organize documentation
Output: Workpaper binder, PBC tracking, organized evidence
```

### Workpaper Review
```
Input: Prepared workpapers, review checklist, auditor requests
Process: Review documentation, address comments, finalize papers
Output: Review-ready workpapers, resolved comments, certifications
```

## Integration

### Used By Processes
- External Audit Coordination
- Internal Audit Planning and Execution
- SOX Compliance and Testing

### Tools and Libraries
- Audit workpaper platforms
- Document management APIs
- Collaboration tools
- Archive systems

## Best Practices

1. Establish standard workpaper formats
2. Complete PBC items before audit fieldwork
3. Document audit trail clearly
4. Cross-reference all key items
5. Maintain workpaper index
6. Archive according to retention policy
