---
name: autosar-config
description: AUTOSAR Classic and Adaptive Platform configuration and implementation expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - automotive-software
    - autosar
    - ecu
    - embedded
---

# AUTOSAR Configuration Skill

## Purpose
Provide AUTOSAR Classic and Adaptive Platform configuration and implementation expertise for automotive ECU software development.

## Capabilities
- Software component (SWC) design and modeling
- RTE configuration and code generation
- Basic Software (BSW) module configuration
- AUTOSAR COM stack setup
- Memory stack configuration (NvM, Fee, Ea)
- Diagnostic stack configuration (Dcm, Dem)
- AUTOSAR Adaptive Platform services
- ARXML file generation and validation

## Usage Guidelines
- Design SWC interfaces following AUTOSAR methodology
- Configure RTE for proper scheduling and communication
- Set up BSW modules according to ECU requirements
- Implement diagnostic services per UDS standards
- Validate ARXML against AUTOSAR schema
- Document configuration decisions and rationale

## Dependencies
- Vector DaVinci
- ETAS ISOLAR
- EB tresos
- Artop

## Process Integration
- ASD-001: AUTOSAR Architecture Implementation
- ASD-002: ECU Software Development and Testing
- ASD-003: Diagnostic Implementation (UDS/OBD)
