# AWS Cloud Skill

AWS-specific infrastructure and services expertise for cloud operations and architecture.

## ID
SK-011

## Category
Cloud Infrastructure

## Quick Reference

| Aspect | Details |
|--------|---------|
| Slug | `aws-cloud` |
| Primary Use | AWS infrastructure, EKS, networking, IAM |
| Dependencies | AWS CLI, credentials, eksctl |
| Process Integration | iac-implementation.js, kubernetes-setup.js, cost-optimization.js, disaster-recovery-plan.js |

## Key Capabilities

- **Compute**: EC2, ECS, Lambda, Auto Scaling
- **Kubernetes**: EKS, IRSA, managed node groups
- **Networking**: VPC, ALB/NLB, Route53, CloudFront
- **Security**: IAM policies, Security Groups, KMS
- **IaC**: CloudFormation, CDK, SAM

## When to Use

Use this skill when you need to:
- Provision AWS infrastructure
- Set up and manage EKS clusters
- Configure AWS networking
- Design and review IAM policies
- Optimize AWS costs

## Related

- **Skills**: terraform-iac (SK-002), kubernetes-ops (SK-001), cloud-cost-analysis (SK-015)
- **Agents**: infra-architect (AG-003), finops-expert (AG-009)
