# Bash Script Template Skill

Generate bash script templates with best practices for error handling and portability.

## Overview

This skill generates robust bash script templates with proper error handling, argument parsing, logging, and portability considerations.

## When to Use

- Creating new bash scripts
- Setting up error handling patterns
- Implementing argument parsing
- Creating portable shell scripts

## Features

- Strict mode (set -euo pipefail)
- Argument parsing with getopts
- Color-coded logging
- Cleanup trap handling
- Long option support

## Integration with Processes

| Process | Integration |
|---------|-------------|
| shell-script-development | Script templates |
| cross-platform-cli-compatibility | Portable patterns |
| cli-application-bootstrap | Shell CLI setup |
