---
name: benefits-tracking-dashboard
description: Track and visualize benefit realization against targets
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: project-management
  domain: business
  category: Benefits Management
  id: SK-011
---

# Benefits Tracking Dashboard

## Overview

The Benefits Tracking Dashboard skill provides comprehensive tracking and visualization of benefit realization against defined targets. It supports the full benefits management lifecycle from definition through sustainment, enabling organizations to demonstrate value delivery from project investments.

## Capabilities

### Benefit Definition
- Define benefit metrics and KPIs
- Establish benefit baselines and targets
- Create benefit measurement plans
- Link benefits to strategic objectives
- Map benefit dependencies and enablers

### Realization Tracking
- Track benefit baseline vs. actual
- Generate benefit realization curves
- Monitor leading and lagging indicators
- Calculate ROI and value delivered
- Measure time-to-benefit

### Visualization and Reporting
- Create benefit realization dashboards
- Generate benefit dependency visualizations
- Produce benefit owner reports
- Build executive benefit summaries
- Generate trend analysis charts

### Alerts and Governance
- Alert on benefit realization risks
- Track benefit ownership accountability
- Monitor benefit sustainability
- Identify dis-benefits and negative impacts
- Generate governance review materials

## Usage

### Input Requirements
- Benefit register with definitions
- Baseline measurements
- Target values and timeframes
- Actual measurement data
- Benefit ownership assignments

### Output Deliverables
- Benefit realization dashboard
- Benefit tracking report
- ROI calculations
- Realization curve charts
- Risk and issue alerts

### Example Use Cases
1. **Post-Implementation Review**: Assess benefits achieved
2. **Governance Reporting**: Report realization status
3. **Portfolio Review**: Compare benefit delivery across projects
4. **Sustainment Monitoring**: Track ongoing benefit levels

## Process Integration

This skill integrates with the following processes:
- benefits-realization.js
- portfolio-prioritization.js
- Business Case Development
- Lessons Learned and Knowledge Management

## Dependencies

- Dashboard visualization libraries
- KPI tracking frameworks
- Alerting systems
- Data integration utilities

## Related Skills

- SK-009: NPV/IRR Calculator
- SK-013: Portfolio Optimization
- SK-018: Lessons Learned Repository
