---
name: bioethics-deliberation
description: Apply bioethical principles (autonomy, beneficence, non-maleficence, justice) and case-based reasoning to healthcare decisions, research protocols, and clinical dilemmas
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Bioethics Deliberation Skill

Apply bioethical principles and case-based reasoning to healthcare decisions and clinical dilemmas.

## Overview

The Bioethics Deliberation skill enables application of bioethical principles including autonomy, beneficence, non-maleficence, and justice, along with case-based reasoning, to analyze healthcare decisions, evaluate research protocols, and address clinical ethical dilemmas.

## Capabilities

### Principle Application
- Apply autonomy considerations
- Assess beneficence requirements
- Evaluate non-maleficence concerns
- Consider justice implications
- Balance competing principles

### Case-Based Reasoning
- Analyze cases systematically
- Identify relevant precedents
- Apply casuistic methods
- Draw appropriate analogies
- Develop case judgments

### Clinical Ethics Analysis
- Address end-of-life issues
- Evaluate informed consent
- Analyze treatment decisions
- Consider patient values
- Support clinical judgment

### Research Ethics
- Evaluate protocol ethics
- Assess risk-benefit ratios
- Review consent procedures
- Consider vulnerable populations
- Apply research standards

### Committee Deliberation
- Facilitate ethical discussion
- Present balanced analyses
- Build consensus
- Document reasoning
- Support decision-making

## Usage Guidelines

### When to Use
- Analyzing clinical dilemmas
- Reviewing research protocols
- Consulting on cases
- Teaching bioethics
- Developing policies

### Best Practices
- Consider all stakeholders
- Apply multiple frameworks
- Document reasoning clearly
- Respect diversity of views
- Seek appropriate consultation

### Integration Points
- Ethical Framework Application skill
- Socratic Dialogue Facilitation skill
- Evidence and Justification Assessment skill
- Scholarly Literature Synthesis skill

## References

- Bioethics Committee Deliberation process
- Applied Ethics Case Analysis process
- Moral Reasoning Framework Application process
- Ethics Consultant Agent
