---
name: blue-ocean-strategy
description: Value innovation and market space creation analysis using Blue Ocean frameworks
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - WebSearch
  - WebFetch
metadata:
  specialization: business-strategy
  domain: business
  category: Market Creation
  skill-id: SK-008
---

# Blue Ocean Strategy Skill

## Overview

The Blue Ocean Strategy skill enables systematic value innovation and market space creation analysis. It provides comprehensive capabilities for analyzing current competitive landscapes, identifying non-customers, and designing new value curves that create uncontested market space where competition becomes irrelevant.

## Capabilities

### Strategy Canvas Creation
- Map current industry competing factors
- Plot competitor value curves
- Visualize competitive convergence
- Identify industry strategic groups
- Highlight differentiation opportunities

### Competing Factors Identification
- Identify factors the industry competes on
- Assess factor importance to buyers
- Evaluate factor investment levels
- Map factor trends over time
- Benchmark against adjacent industries

### Three Tiers of Non-Customer Analysis
- Analyze soon-to-be non-customers (tier 1)
- Study refusing non-customers (tier 2)
- Explore unexplored non-customers (tier 3)
- Identify commonalities across tiers
- Quantify non-customer opportunity size

### Six Paths Framework Application
- Path 1: Look across alternative industries
- Path 2: Look across strategic groups
- Path 3: Look across buyer groups
- Path 4: Look across complementary offerings
- Path 5: Look across functional-emotional orientation
- Path 6: Look across time and trends

### Four Actions Framework (ERRC Grid)
- Eliminate factors to remove
- Reduce factors below industry standard
- Raise factors above industry standard
- Create new factors never offered
- Design coherent ERRC strategy

### New Value Curve Design
- Design divergent value curve
- Ensure focus on key factors
- Craft compelling tagline
- Validate strategic logic
- Test for blue ocean criteria

### Buyer Utility Mapping
- Map buyer experience cycle stages
- Assess utility levers at each stage
- Identify utility blocks and pain points
- Design utility improvements
- Create buyer utility map

### Strategic Pricing Corridor
- Identify price corridor of the mass
- Analyze same form pricing
- Analyze different form, same function
- Analyze different form and function, same objective
- Set strategic price for adoption

### Target Costing from Strategic Price
- Calculate target cost from strategic price
- Assess current cost structure
- Identify cost innovation opportunities
- Design for target cost achievement
- Balance cost and value

### Adoption Hurdle Assessment
- Identify cognitive hurdles
- Assess resource hurdles
- Evaluate motivational hurdles
- Address political hurdles
- Design hurdle mitigation strategies

### Tipping Point Leadership Application
- Identify kingpins for disproportionate influence
- Design fishbowl management
- Leverage atomization
- Create fair process for commitment
- Orchestrate tipping point execution

## Process Integration

This skill integrates with the following processes:

- **blue-ocean-strategy.js**: Primary process for all phases of Blue Ocean analysis
- **competitive-intelligence.js**: Provides current state competitive analysis
- **value-proposition-design.js**: Supports value innovation development
- **business-model-canvas.js**: Enables new business model design

## Usage

### Complete Blue Ocean Analysis
```
Use the blue-ocean-strategy skill to create uncontested market space:
1. Create strategy canvas of current state
2. Analyze three tiers of non-customers
3. Apply Six Paths Framework for insights
4. Design ERRC grid for value innovation
5. Create new value curve
6. Set strategic pricing corridor
7. Calculate target cost
8. Plan tipping point execution
```

### Value Innovation Design
```
Use the blue-ocean-strategy skill to design value innovation:
1. Map current competing factors
2. Identify factors to eliminate and reduce
3. Identify factors to raise and create
4. Design divergent value curve
5. Validate blue ocean potential
```

### Market Space Creation
```
Use the blue-ocean-strategy skill to identify new markets:
1. Analyze non-customer tiers
2. Apply Six Paths Framework
3. Identify blue ocean opportunities
4. Size market creation potential
5. Prioritize opportunities
```

## Dependencies

- Blue Ocean Strategy tools and templates
- Strategy canvas visualization libraries
- ERRC grid templates
- Buyer utility mapping frameworks
- Strategic pricing analysis tools

## Best Practices

1. **Focus on Non-Customers**: The biggest growth lies in non-customers, not fighting for existing customers
2. **Seek Value Innovation**: Pursue differentiation AND low cost simultaneously
3. **Reconstruct Market Boundaries**: Use Six Paths to break conventional industry logic
4. **Get the Strategic Sequence Right**: Utility, price, cost, adoption - in that order
5. **Build Execution into Strategy**: Use fair process to build commitment

## Output Formats

- Strategy Canvas Visualization
- ERRC Grid Document
- Non-Customer Analysis Report
- Six Paths Framework Analysis
- Buyer Utility Map
- Strategic Pricing Analysis
- Blue Ocean Opportunity Assessment
- Tipping Point Execution Plan
