---
name: bms-development
description: Battery system design, BMS algorithm development, and validation expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - electrification
    - battery
    - bms
    - ev
---

# Battery Management System Skill

## Purpose
Provide comprehensive battery system design and BMS algorithm development capabilities for electric vehicle applications including state estimation and thermal management.

## Capabilities
- Cell characterization data analysis (HPPC, capacity, OCV)
- State-of-Charge (SoC) estimation algorithms
- State-of-Health (SoH) estimation methods
- Cell balancing strategy implementation
- Thermal management system sizing
- Battery pack electrical design
- Fault detection and diagnostics
- Abuse testing scenario definition

## Usage Guidelines
- Characterize cells across full temperature and SOC range
- Validate SoC algorithms against reference methods
- Design thermal management for worst-case conditions
- Implement robust fault detection for safety
- Consider cell aging in lifetime predictions
- Document battery specifications and safety limits

## Dependencies
- GT-SUITE
- AVL CRUISE M
- MATLAB/Simulink
- Battery testing equipment

## Process Integration
- PTE-001: Battery System Design and Validation
- PTE-004: Powertrain Calibration and Optimization
- SAF-001: Functional Safety Development (ISO 26262)
