# Bubble Tea Scaffolder Skill

Generate Bubble Tea TUI applications in Go with Elm architecture patterns.

## Overview

This skill scaffolds terminal UI applications using Bubble Tea, the popular Go TUI framework that implements the Elm architecture with Model-Update-View pattern.

## When to Use

- Building terminal UIs in Go
- Creating interactive CLIs with Elm architecture
- Implementing complex TUI applications
- Setting up Bubble Tea projects

## Quick Start

```json
{
  "projectName": "my-tui",
  "modulePath": "github.com/user/my-tui",
  "components": ["list", "textinput", "spinner"]
}
```

## Features

- Elm architecture (Model-Update-View)
- Bubble Tea components
- Lip Gloss styling
- Command handling
- Testing patterns

## Integration with Processes

| Process | Integration |
|---------|-------------|
| tui-application-framework | Go TUI setup |
| dashboard-monitoring-tui | Display components |
| interactive-form-implementation | Input handling |
