---
name: buyer-universe-builder
description: Builds and maintains buyer lists with acquisition history, strategic fit
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: venture-capital
  domain: business
  skill-id: vc-skill-039
---

# Buyer Universe Builder

## Overview

The Buyer Universe Builder skill creates and maintains comprehensive lists of potential acquirers for portfolio companies. It analyzes strategic fit, acquisition history, and buyer capacity to support exit planning and M&A execution.

## Capabilities

### Buyer Identification
- Identify strategic acquirers
- Map financial buyer landscape
- Track international buyers
- Monitor emerging acquirers

### Acquisition History Analysis
- Track historical M&A activity
- Analyze acquisition patterns
- Identify acquisition criteria
- Monitor valuation tendencies

### Strategic Fit Assessment
- Evaluate product/technology fit
- Assess geographic expansion rationale
- Analyze customer base synergies
- Consider talent acquisition angle

### Buyer Prioritization
- Rank buyers by likelihood
- Score strategic fit
- Assess financial capacity
- Consider relationship factors

## Usage

### Build Buyer Universe
```
Input: Portfolio company profile
Process: Identify and categorize buyers
Output: Comprehensive buyer list
```

### Analyze Acquirer
```
Input: Potential acquirer
Process: Deep dive on acquisition patterns
Output: Acquirer profile, fit assessment
```

### Prioritize Buyers
```
Input: Buyer universe, prioritization criteria
Process: Score and rank buyers
Output: Prioritized buyer list
```

### Track Market Activity
```
Input: Sector/segment focus
Process: Monitor M&A activity
Output: Market activity report
```

## Buyer Categories

| Category | Characteristics |
|----------|-----------------|
| Strategic - Large | Big tech, major players |
| Strategic - Mid | Mid-market acquirers |
| Private Equity | Financial buyers |
| International | Cross-border interest |
| Emerging | New entrant acquirers |

## Integration Points

- **Exit Readiness Assessment**: Support exit planning
- **Exit Planner (Agent)**: Enable agent analysis
- **M&A Advisor (Agent)**: Support execution
- **Comparable Transaction Finder**: M&A precedents

## Fit Assessment Criteria

| Criterion | Evaluation Points |
|-----------|-------------------|
| Product | Technology fit, roadmap acceleration |
| Market | Customer overlap, geographic expansion |
| Team | Talent acquisition, leadership |
| Financial | Revenue synergies, cost savings |
| Strategic | Competitive defense, platform |

## Best Practices

1. Maintain buyer lists proactively
2. Track buyer behavior over time
3. Consider non-obvious buyers
4. Monitor corporate development contacts
5. Update following market transactions
