# CAN Bus Skill

CAN/CAN-FD bus analysis and development for automotive and industrial systems.

## Purpose

Provides comprehensive CAN bus development support:
- Message frame generation and analysis
- DBC file parsing and signal decoding
- J1939 and CANopen protocol support
- Bus arbitration and error analysis
- CAN-FD configuration and validation

## Key Features

- CAN 2.0A/B and CAN-FD support
- DBC file integration
- J1939, CANopen, UDS protocols
- Bus load and error analysis
- Gateway and routing configuration

## Integration

Used by processes requiring CAN expertise:
- Device driver development
- Signal integrity testing
- Interface specification
- Functional safety certification

## Dependencies

- CAN interface tools (PEAK, Vector, Kvaser)
- DBC files for signal definitions
- CAN analyzer hardware
