---
name: care-transition-coordination
description: Manage care transitions between settings including discharge planning, medication reconciliation, follow-up scheduling, and post-acute care coordination
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Care Transition Coordination

Manage care transitions between settings including discharge planning, medication reconciliation, follow-up scheduling, and post-acute care coordination.

## Overview

This skill enables effective coordination of care transitions across healthcare settings. It encompasses discharge planning, medication reconciliation, follow-up coordination, and communication to ensure safe and effective care continuity.

## Capabilities

### Discharge Planning
- Assess patient needs
- Coordinate services
- Arrange equipment
- Plan follow-up care
- Educate patients/families

### Medication Reconciliation
- Review medication lists
- Identify discrepancies
- Resolve conflicts
- Update records
- Educate patients

### Follow-Up Coordination
- Schedule appointments
- Arrange transportation
- Coordinate referrals
- Track completion
- Manage barriers

### Post-Acute Coordination
- Assess placement needs
- Coordinate with facilities
- Transfer information
- Monitor transitions
- Address issues

## Usage Guidelines

### Transition Process
1. Identify transition needs early
2. Assess patient/family situation
3. Develop transition plan
4. Coordinate necessary services
5. Reconcile medications
6. Provide education
7. Execute transition
8. Follow up

### Communication Standards
- Timely information transfer
- Complete documentation
- Clear handoff communication
- Patient education materials
- Provider notifications

### Risk Mitigation
- Identify high-risk patients
- Address social determinants
- Ensure medication safety
- Verify follow-up completion
- Monitor for readmissions

## Integration Points

### Related Processes
- Discharge Planning Process
- Care Coordination Protocol
- Population Health Management Program

### Collaborating Skills
- clinical-workflow-analysis
- population-health-stratification
- health-data-integration

## References

- CMS discharge planning requirements
- AHRQ care transitions resources
- Coleman Care Transitions Model
- BOOST program
