---
name: certification-planning
description: Expert skill for aerospace certification planning aligned with regulatory requirements
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: aerospace-engineering
  tags:
    - certification
    - regulatory
    - compliance
    - airworthiness
---

# Certification Planning Skill

## Purpose
Provide expert aerospace certification planning capabilities for FAR/EASA compliance, type certification, and regulatory coordination.

## Capabilities
- FAR/EASA certification basis definition
- Means of compliance identification
- Certification plan development
- Type certificate data sheet preparation
- Compliance document tracking
- DER/DAR coordination support
- Issue paper management
- Equivalent safety finding support

## Usage Guidelines
- Establish certification basis early in program
- Identify novel or unusual features requiring special conditions
- Develop detailed means of compliance for each requirement
- Coordinate with certification authorities throughout development
- Track compliance status and document evidence
- Prepare for certification reviews and audits

## Dependencies
- FAR/CS requirements databases
- Certification tracking tools
- Document management systems

## Process Integration
- AE-021: Certification Planning
