---
name: character-development
id: SK-FTV-007
version: 1.0.0
description: Build complete character profiles with psychology, backstory, arcs, and visual design for film/TV
specialization: film-tv-production
---

# Character Development Skill

## Purpose

Create three-dimensional, compelling characters with depth, complexity, and clear arcs. Characters drive stories—understanding their psychology, history, and desires enables authentic dialogue and meaningful narrative choices.

## The CHARACTER Framework

### C - Core
**Fundamental nature, values, moral code**

| Element | Questions to Answer |
|---------|---------------------|
| Values | What matters most to them? |
| Morality | Where are their ethical lines? |
| Worldview | How do they see the world? |
| Philosophy | What do they believe about life? |
| Identity | How do they define themselves? |

### H - History
**Backstory and formative experiences**

| Element | Purpose |
|---------|---------|
| Origin | Where they came from |
| Family | Relationships that shaped them |
| Trauma | The wound that drives them |
| Victories | What they're proud of |
| Regrets | What haunts them |

### A - Ambition
**Goals, desires, needs**

| Type | Description |
|------|-------------|
| Want | Conscious goal (what they pursue) |
| Need | Unconscious need (what they truly require) |
| Motivation | Why they pursue their goals |
| Stakes | What they'll lose if they fail |

### R - Relationships
**Connections and dynamics**

| Relationship | Dynamics to Define |
|--------------|-------------------|
| Allies | Who supports them |
| Enemies | Who opposes them |
| Lovers | Romantic connections |
| Family | Blood/chosen family |
| Mentors | Who guides them |

### A - Arc
**Transformation journey**

| Stage | Description |
|-------|-------------|
| Starting State | Who they are at opening |
| Catalyst | What forces change |
| Struggle | Resistance to change |
| Revelation | Moment of truth |
| Transformation | New understanding |
| Ending State | Who they become |

### C - Contradiction
**Internal conflict and complexity**

| Element | Purpose |
|---------|---------|
| Flaw | Fatal flaw that creates problems |
| Blind Spot | What they can't see about themselves |
| Self-Deception | Lies they tell themselves |
| Paradox | Contradictory traits |

### T - Talk
**Voice and speech patterns**

| Element | Specifications |
|---------|----------------|
| Vocabulary | Education, profession, culture |
| Syntax | Sentence structure preferences |
| Rhythm | Pace, pauses, patterns |
| Quirks | Verbal tics, catchphrases |
| Silence | When they go quiet |

### E - Exterior
**Physical and behavioral**

| Element | Details |
|---------|---------|
| Appearance | Physical description |
| Movement | How they carry themselves |
| Gestures | Habitual actions |
| Style | Wardrobe, grooming |
| Presence | Energy in a room |

### R - Resonance
**Thematic connection**

| Element | Connection |
|---------|------------|
| Theme | What universal truth they embody |
| Symbol | What they represent |
| Foil | Who they contrast with |
| Message | What their arc teaches |

## The Lie and the Truth

Every compelling character believes a lie that their arc helps them overcome:

```
THE LIE          → What they believe
                    "I don't need anyone"

THE TRUTH        → What they must learn
                    "Connection gives life meaning"

THE GHOST        → Why they believe the lie
                    "Abandoned by parents at age 8"

THE WOUND        → How the ghost manifests
                    "Pushes people away before they can leave"
```

## Arc Types

### Positive Change Arc
Character overcomes flaw, learns truth
- Starts believing lie
- Circumstances force confrontation
- Rejects truth initially
- Crisis forces acceptance
- Transforms for better

### Negative Change Arc (Tragedy)
Character succumbs to flaw
- Starts with potential
- Circumstances tempt
- Chooses wrong path
- Doubles down on lie
- Destroyed by flaw

### Flat Arc (Testing)
Character's truth is tested
- Already knows truth
- World challenges belief
- Maintains conviction
- Changes world around them
- Truth proven correct

### Corruption Arc (Fall)
Good character corrupted
- Starts with strong values
- Compromises begin small
- Each step justified
- Values inverted
- Becomes what they fought

## Character Profile Template

```markdown
# [CHARACTER NAME]

## Overview
- **Role:** [Protagonist/Antagonist/Supporting]
- **Archetype:** [Archetype reference]
- **One-Line:** [Character in one sentence]

## Core (Who They Are)
- **Values:**
- **Moral Code:**
- **Worldview:**
- **Self-Identity:**

## History (Where They Came From)
- **Background:**
- **Formative Experience:**
- **The Ghost:**
- **Key Relationships:**

## Psychology
- **Want:** [Conscious goal]
- **Need:** [Unconscious need]
- **Fear:** [Greatest fear]
- **Flaw:** [Fatal flaw]
- **Lie:** [False belief]
- **Truth:** [Must learn]

## Arc
- **Starting State:**
- **Catalyst:**
- **Transformation:**
- **Ending State:**
- **Arc Type:**

## Exterior
- **Age:**
- **Physical:**
- **Style:**
- **Mannerisms:**

## Voice
- **Speech Pattern:**
- **Vocabulary:**
- **Verbal Quirks:**
- **Sample Dialogue:**

## Relationships
- **[Name]:** [Relationship dynamic]
- **[Name]:** [Relationship dynamic]

## Visual Reference
[Image prompt for character visualization]
```

## Character Types

### Protagonist
- Active, not passive
- Drives the story
- Has most to lose
- Changes most (usually)

### Antagonist
- Believes they're right
- Formidable opposition
- Dark mirror to protagonist
- Understandable motivation

### Supporting
- Serves protagonist's arc
- Has distinct function
- Own goals beyond service
- Clear voice

### Foil
- Contrasts protagonist
- Highlights traits
- Different choices
- Shared opportunities

## Common Mistakes

1. **Perfect characters** - No flaws = no growth
2. **Villain without motive** - Evil for evil's sake
3. **Passive protagonist** - Things happen TO them
4. **Same voice** - All characters sound alike
5. **Arc without setup** - Change feels unearned
6. **Backstory dump** - History without relevance
