---
name: citation-scholarly-apparatus
description: Format citations, footnotes, and bibliographies following Chicago, MLA, and disciplinary style guides with accuracy
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Citation and Scholarly Apparatus

Format citations, footnotes, and bibliographies following Chicago, MLA, and disciplinary style guides with accuracy.

## Overview

This skill enables professional scholarly citation and documentation. It encompasses citation formatting, footnote construction, and bibliography compilation following appropriate disciplinary style guides.

## Capabilities

### Citation Styles
- Chicago Manual of Style
- MLA Handbook
- APA Style
- Disciplinary variations
- Digital source citation

### Footnote Construction
- Note formatting
- Subsequent citations
- Ibid/op. cit. usage
- Explanatory notes
- Content notes

### Bibliography Compilation
- Entry formatting
- Alphabetization
- Annotation writing
- Category organization
- Source verification

### Reference Management
- Reference software usage
- Database maintenance
- Export formatting
- Style switching
- Batch processing

## Usage Guidelines

### Citation Process
1. Identify source type
2. Gather required elements
3. Format according to style
4. Verify accuracy
5. Maintain consistency
6. Update as needed
7. Check final version

### Style Selection
- Follow publication requirements
- Match disciplinary conventions
- Maintain consistency
- Document variations
- Update for new editions

### Quality Standards
- Complete information
- Accurate formatting
- Consistent application
- Verified sources
- Clear presentation

## Integration Points

### Related Processes
- Scholarly Article Development
- Textual Criticism and Editing
- Historical Narrative Construction

### Collaborating Skills
- grant-narrative-writing
- literary-close-reading
- primary-source-evaluation

## References

- Chicago Manual of Style
- MLA Handbook
- Turabian manual
- Reference management guides
