---
name: clinical-decision-support-rules
description: Develop and maintain clinical decision support rules including alerts, reminders, order sets, and evidence-based recommendations within EHR systems
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# Clinical Decision Support Rules

Develop and maintain clinical decision support rules including alerts, reminders, order sets, and evidence-based recommendations within EHR systems.

## Overview

This skill enables development and maintenance of clinical decision support within EHR systems. It encompasses rule design, alert management, order set development, and optimization to support clinical decision-making.

## Capabilities

### Alert Development
- Drug-drug interactions
- Drug-allergy checking
- Dose range alerts
- Duplicate order checking
- Clinical reminders

### Order Set Design
- Evidence-based orders
- Condition-specific sets
- Workflow integration
- Preference lists
- Protocol embedding

### Rule Logic
- Trigger conditions
- Action specifications
- Suppression rules
- Override tracking
- Escalation logic

### Optimization
- Alert fatigue reduction
- Sensitivity/specificity tuning
- Override analysis
- Effectiveness monitoring
- Continuous improvement

## Usage Guidelines

### Development Process
1. Identify clinical need
2. Review evidence base
3. Design rule logic
4. Build in test environment
5. Validate with clinicians
6. Deploy carefully
7. Monitor and optimize

### Design Principles
- Clinical relevance
- Workflow integration
- Minimal disruption
- Actionable guidance
- Evidence-based content

### Maintenance Requirements
- Regular content review
- Performance monitoring
- Override analysis
- User feedback integration
- Evidence updates

## Integration Points

### Related Processes
- Clinical Decision Support Implementation
- Clinical Pathway Development
- EHR Implementation Methodology

### Collaborating Skills
- health-data-integration
- clinical-workflow-analysis
- quality-metrics-measurement

## References

- ONC CDS framework
- AHRQ CDS resources
- Clinical informatics standards
- EHR vendor guidelines
