---
name: clinical-workflow-analysis
description: Analyze clinical workflows to identify inefficiencies, bottlenecks, and improvement opportunities using Lean healthcare principles and value stream mapping techniques
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Clinical Workflow Analysis

Analyze clinical workflows to identify inefficiencies, bottlenecks, and improvement opportunities using Lean healthcare principles and value stream mapping techniques.

## Overview

This skill enables systematic analysis of clinical workflows in healthcare settings. It encompasses process mapping, waste identification, bottleneck analysis, and improvement opportunity identification using Lean healthcare methodologies.

## Capabilities

### Process Mapping
- Create current state maps
- Document workflow steps
- Identify handoffs and decision points
- Map information flows
- Capture time metrics

### Value Stream Analysis
- Distinguish value-added activities
- Identify non-value-added steps
- Calculate process efficiency
- Map patient flow
- Analyze cycle times

### Bottleneck Identification
- Identify capacity constraints
- Analyze queue buildups
- Assess resource utilization
- Find delay causes
- Measure wait times

### Improvement Planning
- Design future state workflows
- Prioritize improvement opportunities
- Develop implementation plans
- Define success metrics
- Plan change management

## Usage Guidelines

### Analysis Process
1. Define scope and objectives
2. Observe and document current state
3. Create process maps
4. Collect time and volume data
5. Identify wastes and constraints
6. Develop improvement recommendations
7. Design future state

### Lean Healthcare Wastes
- Defects (errors, rework)
- Overproduction (unnecessary services)
- Waiting (delays)
- Non-utilized talent
- Transportation (unnecessary movement)
- Inventory (excess supplies)
- Motion (unnecessary steps)
- Extra processing

### Documentation Standards
- Use standard mapping notation
- Include quantitative data
- Document assumptions
- Note data sources
- Maintain version control

## Integration Points

### Related Processes
- Patient Flow Optimization
- Care Coordination Protocol
- Clinical Pathway Development

### Collaborating Skills
- quality-metrics-measurement
- workforce-demand-forecasting
- health-data-integration

## References

- Lean healthcare methodologies
- Value stream mapping standards
- Institute for Healthcare Improvement resources
- Process improvement frameworks
