# Cloud Cost Analysis Skill

Multi-cloud cost analysis and optimization expertise for FinOps practices.

## ID
SK-015

## Category
FinOps

## Quick Reference

| Aspect | Details |
|--------|---------|
| Slug | `cloud-cost-analysis` |
| Primary Use | Cloud cost analysis, optimization, and FinOps |
| Dependencies | Cloud billing API access |
| Process Integration | cost-optimization.js, auto-scaling.js, iac-implementation.js |

## Key Capabilities

- **AWS**: Cost Explorer, CUR, Reserved Instances, Savings Plans
- **GCP**: Billing export, CUDs, Recommender API
- **Azure**: Cost Management, Reserved VMs, Azure Advisor
- **Optimization**: Rightsizing, idle resources, storage tiers
- **Governance**: Tagging, budgets, cost policies

## When to Use

Use this skill when you need to:
- Analyze cloud spending across providers
- Identify cost optimization opportunities
- Implement cost allocation and tagging
- Set up budgets and alerts
- Design cost governance policies

## Related

- **Skills**: aws-cloud (SK-011), gcp-cloud (SK-012), azure-cloud (SK-013)
- **Agents**: finops-expert (AG-009), infra-architect (AG-003)
